<?php
/**
 * Wishlist pages template; load template parts basing on the url
 *
 * @author YITH <plugins@yithemes.com>
 * @package YITH\Wishlist\Templates\Wishlist
 * @version 3.0.0
 */

/**
 * Template Variables:
 *
 * @var $template_part string Sub-template to load
 * @var $var array Array of attributes that needs to be sent to sub-template
 */

if ( ! defined( 'YITH_WCWL' ) ) {
	exit;
} // Exit if accessed directly
$indusza_redux_demo = get_option('redux_demo');
?>

<?php if(isset($indusza_redux_demo['shop_banner']['url']) && $indusza_redux_demo['shop_banner']['url'] != ''){?>
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo esc_url($indusza_redux_demo['shop_banner']['url']);?>);">
<?php }else{?> 
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo (get_template_directory_uri().'/assets/images/banner/1.jpg');?>);">
<?php } ?>
    <div class="overlay-main site-bg-black opacity-06"></div>
    <div class="container">
        <div class="wt-bnr-inr-entry">
            <div class="banner-title-outer">
                <div class="banner-title-name">
                    <h2 class="wt-title"><?php if(isset($indusza_redux_demo['wishlist_title']) && $indusza_redux_demo['wishlist_title'] != ''){?>
                        <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['wishlist_title']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'Wishlist', 'indusza' );
                    }
                ?></h2>
                </div>
            </div>
            <div>
                <ul class="wt-breadcrumb breadcrumb-style-2">
                    <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($indusza_redux_demo['home'])){?>
                        <?php echo esc_attr($indusza_redux_demo['home']);?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Home', 'indusza' );}?></a></li>
                    <li><?php if(isset($indusza_redux_demo['wishlist_title']) && $indusza_redux_demo['wishlist_title'] != ''){?>
                        <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['wishlist_title']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'Wishlist', 'indusza' );
                    }
                ?></li>
                </ul>
            </div>
            <!-- BREADCRUMB ROW END -->                        
        </div>
    </div>
</div>

	<div class="section-full content-inner page-wishlist">
		<div class="container">
			<div class="row">
				<div class="col-md-12 ">
					<?php
				/**
				 * DO_ACTION: yith_wcwl_wishlist_before_wishlist_content
				 *
				 * Allows to render some content or fire some action before the wishlist content.
				 *
				 * @param array $var Array of attributes that needs to be sent to sub-template
				 */
				do_action( 'yith_wcwl_wishlist_before_wishlist_content', $var );
				?>
				
				<?php
				/**
				 * DO_ACTION: yith_wcwl_wishlist_before_wishlist_content
				 *
				 * Allows to render some content or fire some action in the wishlist content.
				 *
				 * @param array $var Array of attributes that needs to be sent to sub-template
				 */
				do_action( 'yith_wcwl_wishlist_main_wishlist_content', $var );
				?>

				<?php
				/**
				 * DO_ACTION: yith_wcwl_wishlist_after_wishlist_content
				 *
				 * Allows to render some content or fire some action after the wishlist content.
				 *
				 * @param array $var Array of attributes that needs to be sent to sub-template
				 */
				do_action( 'yith_wcwl_wishlist_after_wishlist_content', $var ); ?>
			</div>
		</div>
	</div>
</div>