<?php

/**
 * adds the 'edit table' meta box
 * @author jacek
 */
class ctSizeGuideTable
{
    /**
     * Init object
     */

    public function __construct()
    {
        add_action('add_meta_boxes', array($this, 'editSizeGuideTable'));
        add_action('add_meta_boxes', array($this, 'editSizeGuideSettings'));
        add_action('save_post_ct_size_guide', array($this, 'saveSizeGuideTable'));
        add_action('edit_post_ct_size_guide', array($this, 'saveSizeGuideTable'));
    }

    /**
     * Add meta box for size guide
     */

    public function editSizeGuideTable()
    {
        add_meta_box('ct_sizeguidetable', __('Create/modify size guide table', 'ct-sgp'), array(
            $this,
            'renderSizeGuideTableMetaBox'
        ), 'ct_size_guide', 'normal', 'high');
    }

    /**
     * Size Guide Meta box
     *
     * @param $post
     */

    public function renderSizeGuideTableMetaBox($post)
    {
        wp_nonce_field('size_guide_meta_box', 'size_guide_meta_box_nonce');

        $current = get_current_screen()->action;

        $newpost = ($current == 'add');

        $defaultTable = array(
            array('Size', 'Bust', 'Waist', 'Hips'),
            array('8', '32', '25', '35'),
            array('10', '34', '27', '37'),
            array('12', '36', '29', '39'),
        );
        $defaultTitle = __('Table title', 'ct-sgp');
        $defaultCaption = __('Table caption', 'ct-sgp');

        if (!$newpost) {
            $post_id = $post->ID;
            $meta_table = get_post_meta($post_id, '_ct_sizeguide');
            $meta_table = $meta_table[0];
        } else {
            $meta_table[0] = array(
                'title' => $defaultTitle,
                'table' => $defaultTable,
                'caption' => $defaultCaption
            );
        }

        foreach ($meta_table as $key => $table) {

            if (empty($table['table'])) {
                continue;
            }
            $this->sizeGuideTablePreTemplate($table, $key, '');
            $this->sizeGuideTableTemplate($table, $key, '');

        }

        $this->sizeGuideTablePostTemplate($meta_table[0], 0, '');
    }

    public function sizeGuideTablePreTemplate($table, $key, $class = '')
    {

        if (0 == $key) {
            echo '<div class="ct_single_size_table' . ($class ? ' ' . $class : '') . '">';
        }

        echo '<p class="sg-sizeGuide-title-above"><strong>' . __('Text above table', 'ct-sgp') . '</strong></p>';

        $args_title = array(
            'textarea_name' => 'ct_size_guide[' . $key . '][title]',
            'textarea_rows' => 2
        );

        $title = isset($table['title']) ? $table['title'] : '';
        wp_editor($title, 'size_table_caption' . $key, $args_title);
    }

    public function sizeGuideTablePostTemplate($table, $key, $class = '')
    {

        echo '<div id="ct-sizeGuide-tableControl">';
        echo '<button type="button" class="button ct-addTable">' . __('Add Table', 'ct-sgp') . '</button>';
        echo '<button type="button" class="button ct-delTable"><i class="free free-uniE905" aria-hidden="true"></i>' . __('Remove Table', 'ct-sgp') . '</button>';
        echo '</div>';

        echo '<p class="sg-sizeGuide-title-below"><strong>' . __('Table caption', 'ct-sgp') . '</strong></p>';

        $args_caption = array(
            'textarea_name' => 'ct_size_guide[' . $key . '][caption]',
            'textarea_rows' => 2
        );

        wp_editor($table['caption'], 'size_table_title' . $key, $args_caption);
        echo '</div>';
    }

    /**
     * Render table
     *
     * @param $table
     * @param $key
     * @param string $class
     */
    public function sizeGuideTableTemplate($table, $key, $class = '')
    {
        echo '<br>';

        echo '<textarea class="ct_edit_table" name="ct_size_guide[' . $key . '][table]" style="display:none">';
        $table_array = json_encode($table['table']);
        echo $table_array;
        echo '</textarea>';
    }

    /**
     * Add size guide metabox settings
     */

    public function editSizeGuideSettings()
    {
        add_meta_box('ct_sizeguidesettings', __('Size guide settings', 'ct-sgp'), array($this, 'renderSizeGuideSettingsMetaBox'), 'ct_size_guide', 'normal', 'high');
    }

    /**
     * Meta box
     *
     * @param $post
     */

    public function renderSizeGuideSettingsMetaBox($post)
    {
        $current = get_current_screen()->action;

        $newpost = ($current == 'add');

        if (!$newpost) {
            $post_id = $post->ID;
        } else {
            $post_id = get_the_ID(); //returns assign id for new sizeguide post
        }

        wp_nonce_field('size_guide_settings_meta_box', 'size_guide_settings_meta_box_nonce');

        ?>
        <div class="sg-single-setting">
            <div class="sg-single-setting__label">
                <label><?php echo __('Open guide with:', 'ct-sgp'); ?></label>
            </div>
            <div class="sg-single-setting__wrap">
                <select name="size_guide_settings[wc_size_guide_button_style]" class="chosen_select">
                    <option value="global" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_style', 'global'); ?> ><?php echo __('Use global settings', 'ct-sgp'); ?></option>
                    <option value="ct-trigger-link" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_style', 'ct-trigger-link'); ?> > <?php echo __('Link', 'ct-sgp'); ?></option>
                    <option value="ct-trigger-button" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_style', 'ct-trigger-button'); ?> ><?php echo __('Button', 'ct-sgp'); ?></option>
                </select>
                <small><?php echo __('Chose whether to display a simple link or a button to open the size guide.', 'ct-sgp'); ?></small>
            </div>
        </div>

        <div class="sg-single-setting">
            <div class="sg-single-setting__label">
                <label><?php echo __('Button/link position:', 'ct-sgp'); ?></label>
            </div>
            <div class="sg-single-setting__wrap">
                <select name="size_guide_settings[wc_size_guide_button_position]" class="chosen_select">
                    <option value="global" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_position', 'global'); ?> ><?php echo __('Use global settings', 'ct-sgp'); ?></option>
                    <option value="ct-position-price" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_position', 'ct-position-price'); ?> ><?php echo __('Under Price', 'ct-sgp'); ?></option>
                    <option value="ct-position-summary" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_position', 'ct-position-summary'); ?> ><?php echo __('Above the product summary tabs', 'ct-sgp'); ?></option>
                    <option value="ct-position-add-to-cart" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_position', 'ct-position-add-to-cart'); ?> ><?php echo __('After Add To Cart button', 'ct-sgp'); ?></option>
                    <option value="ct-position-info" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_position', 'ct-position-info'); ?> ><?php echo __('After Product Info', 'ct-sgp'); ?></option>
                    <option value="ct-position-tab" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_position', 'ct-position-tab'); ?> ><?php echo __('Make it a tab', 'ct-sgp'); ?></option>
                    <option value="ct-position-shortcode" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_position', 'ct-position-shortcode'); ?> ><?php echo __('Embed manually (shortcode)', 'ct-sgp'); ?></option>
                </select>
                <small><?php echo __('For manual embed, [ct_size_guide] shortcode can be placed anywhere you want. More info can be found <a href="http://createit.support/documentation/size-guide/#doc-7007" target="_blank">here</a>', 'ct-sgp'); ?></small>
            </div>
        </div>

        <div>
            <div class="sg-single-setting">
                <div class="sg-single-setting__label">
                    <label><?php echo __('Button/link hook priority:', 'ct-sgp'); ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <select name="size_guide_settings[wc_size_guide_button_priority_dropdown]" class="chosen_select"
                            id="wc_size_guide_button_priority_dropdown">
                        <option value="global" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_priority_dropdown', 'global'); ?> ><?php echo __('Use global settings', 'ct-sgp'); ?></option>
                        <option value="individual_priority" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_priority_dropdown', 'individual_priority'); ?> ><?php echo __('Use individual settings', 'ct-sgp'); ?></option>
                    </select>
                    <small><?php echo __('Chose whether to use global or individual option to set priority of the action that outputs the button/link. Using this you can adjust the position - check the <a href="http://createit.support/documentation/size-guide/#button-priority">documentation</a> for more information.', 'ct-sgp'); ?></small>
                </div>
            </div>

            <script>
                (function ($) {
                    'use strict';
                    $(document).ready(function () {

                        $("#wc_size_guide_button_priority_dropdown option:selected").each(function () {
                            var selected = $(this).val();
                            if (selected == 'individual_priority') {
                                $("#individual_priority_chosen").css({"display": "block"});
                                var input = $("#individual_priority").val();
                                if (input == 'global') {
                                    $("#individual_priority").val('');
                                }
                            } else {
                                $("#individual_priority_chosen").css({"display": "none"});
                                $("#individual_priority").val('global');
                            }
                        });

                        $("#wc_size_guide_button_priority_dropdown").change(function () {
                            var selected = $(this).val();
                            if (selected == 'individual_priority') {
                                $("#individual_priority_chosen").css({"display": "block"});
                                var input = $("#individual_priority").val();
                                if (input == 'global') {
                                    $("#individual_priority").val('');
                                }
                            } else {
                                $("#individual_priority_chosen").css({"display": "none"});
                                $("#individual_priority").val('global');
                            }
                        });
                    });
                }(jQuery));
            </script>


        </div>
        <div>
            <div class="sg-single-setting" id="individual_priority_chosen" style="display:none">
                <div class="sg-single-setting__label">
                    <label><?php echo __('Individual priority:', 'ct-sgp'); ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <input
                            id="individual_priority"
                            value="<?php echo $this->getNumberValue($post_id, 'wc_size_guide_button_priority', 'global'); ?>"
                            name="size_guide_settings[wc_size_guide_button_priority]"
                            class="chosen_input"
                            type="text"
                    />
                    <small><?php echo __('Type individual priority.', 'ct-sgp'); ?></small>
                </div>
            </div>
        </div>
        <div>
            <div class="sg-single-setting">
                <div class="sg-single-setting__label">
                    <label><?php echo __('Tab Multiple Table:', 'ct-sgp'); ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <select name="size_guide_settings[wc_size_guide_tab_multiple_table]" class="chosen_select">
                        <option value="global" <?php echo $this->getSelected($post_id, 'wc_size_guide_tab_multiple_table', 'global'); ?> ><?php echo __('Use global settings', 'ct-sgp'); ?></option>
                        <option value="yes" <?php echo $this->getSelected($post_id, 'wc_size_guide_tab_multiple_table', 'yes'); ?> ><?php echo __('Yes', 'ct-sgp'); ?></option>
                        <option value="no" <?php echo $this->getSelected($post_id, 'wc_size_guide_tab_multiple_table', 'no'); ?> ><?php echo __('No', 'ct-sgp'); ?></option>
                    </select>
                    <small><?php echo __('Display content as tabs. Each table will be a separate tab. Use \'###[Tab Title]\' to mark when a text description should be broken into a new tab', 'ct-sgp'); ?></small>
                </div>
            </div>
        </div>
        <div>
            <div class="sg-single-setting --tabs-order">
                <div class="sg-single-setting__label">
                    <label for="wc_size_guide_tabs_order"><?php _e('Tabs order', 'ct-sgp') ?></label>
                </div>
                <div class="sg-single-setting__list">
                    <input value="<?php echo implode(";", self::getTabsOrdered($post_id, true)); ?>"
                           name="size_guide_settings[wc_size_guide_tabs_order]" type="hidden"
                           id="wc_size_guide_tabs_order">
                    <div class="sg-single-setting__tab-list">

                        <?php $tabs_items = self::getTabsOrdered($post_id);
                        foreach ($tabs_items as $tab_value => $tab_title):?>
                            <div class="button" data-value="<?php echo esc_attr($tab_value) ?>">
                                <?php echo esc_html(strip_tags($tab_title)) ?></div>
                        <?php endforeach; ?>
                    </div>
                    <small><?php _e('Choose tabs order when using multiple tabs', 'ct-sgp') ?></small>
                </div>
                <script>
                    jQuery(document).ready(function ($) {
                        const tabsOrderInput = $('#wc_size_guide_tabs_order');
                        $(".sg-single-setting__tab-list").sortable({
                            revert: false,
                            update: function (event, ui) {
                                let list = event.target;
                                let items = list.children;
                                let order = [];
                                console.log(items)
                                for (let item of items) {
                                    const value = item.dataset.value;
                                    if (value) {
                                        order.push(value);
                                    }
                                }
                                tabsOrderInput.val(order.join(";"))
                            }
                        });
                    });
                </script>
            </div>
        </div>
        <div>
            <div class="sg-single-setting">
                <div class="sg-single-setting__label">
                    <label><?php echo __('Button/link label:', 'ct-sgp'); ?> </label>
                </div>
                <div class="sg-single-setting__wrap">
                    <select name="size_guide_settings[wc_size_guide_button_label_dropdown]" class="chosen_select"
                            id="wc_size_guide_button_label_dropdown">
                        <option value="global" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_label_dropdown', 'global'); ?> ><?php echo __('Use global settings', 'ct-sgp'); ?> </option>
                        <option value="individual_label" <?php echo $this->getSelected($post_id, 'wc_size_guide_button_label_dropdown', 'individual_label'); ?> ><?php echo __('Use individual settings', 'ct-sgp'); ?> </option>
                    </select>
                    <small> <?php echo __("Chose whether to use global or individual option to display name of the size guide button/link's label.", 'ct-sgp'); ?> </small>
                </div>
            </div>


            <script>
                (function ($) {
                    'use strict';
                    $(document).ready(function () {

                        $("#wc_size_guide_button_label_dropdown option:selected").each(function () {
                            var selected = $(this).val();
                            if (selected == 'individual_label') {
                                $("#individual_label_chosen").css({"display": "block"});
                                var input = $("#individual_label").val();
                                if (input == 'global') {
                                    $("#individual_label").val('');
                                }
                            } else {
                                $("#individual_label_chosen").css({"display": "none"});
                                $("#individual_label").val('global');
                            }
                        });

                        $("#wc_size_guide_button_label_dropdown").change(function () {
                            var selected = $(this).val();
                            if (selected == 'individual_label') {
                                $("#individual_label_chosen").css({"display": "block"});
                                var input = $("#individual_label").val();
                                if (input == 'global') {
                                    $("#individual_label").val('');
                                }
                            } else {
                                $("#individual_label_chosen").css({"display": "none"});
                                $("#individual_label").val('global');
                            }
                        });
                    });
                }(jQuery));
            </script>
        </div>
        <div>
            <div id="individual_label_chosen" style="display:none">
                <div class="sg-single-setting">
                    <div class="sg-single-setting__label">
                        <label><?php _e('Individual label:', 'ct-sgp') ?></label>
                    </div>
                    <div class="sg-single-setting__wrap">
                        <input type="text" name="size_guide_settings[wc_size_guide_button_label]"
                               value="<?php echo $this->getNumberValue($post_id, 'wc_size_guide_button_label', 'global') ?>"
                               class="chosen_input" id="individual_label">
                        <small><?php _e('Type button/link label.', 'ct-sgp') ?></small>
                    </div>
                </div>
            </div>

        </div>

        <div>
        <div class="sg-single-setting">
            <div class="sg-single-setting__label">
                <label><?php _e('Button/link align:', 'ct-sgp') ?></label>
            </div>
            <div class="sg-single-setting__wrap">
                <select name="size_guide_settings[wc_size_guide_button_align]" class="chosen_select">
                    <option value="global" <?php $this->getSelected($post_id, 'wc_size_guide_button_align', 'global') ?>><?php _e('Use global settings', 'ct-sgp') ?></option>
                    <option value="left" <?php $this->getSelected($post_id, 'wc_size_guide_button_align', 'left') ?>><?php _e('Left', 'ct-sgp') ?></option>
                    <option value="right" <?php $this->getSelected($post_id, 'wc_size_guide_button_align', 'right') ?>><?php _e('Right', 'ct-sgp') ?></option>
                </select>
            </div>
        </div>
        <div>
            <div class="sg-single-setting">
                <div class="sg-single-setting__label">
                    <label><?php _e('Button/link clearing:', 'ct-sgp') ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <select
                            name="size_guide_settings[wc_size_guide_button_clear]" class="chosen_select">
                        <option value="global"
                            <?php $this->getSelected($post_id, 'wc_size_guide_button_clear', 'global') ?>><?php _e('Use global
                    settings', 'ct-sgp') ?></option>
                        <option value="yes"
                            <?php $this->getSelected($post_id, 'wc_size_guide_button_clear', 'yes') ?>><?php _e('Yes', 'ct-sgp') ?></option>
                        <option value="no"
                            <?php $this->getSelected($post_id, 'wc_size_guide_button_clear', 'no') ?>><?php _e('No', 'ct-sgp') ?></option>
                    </select><small> <?php _e('Allow floating elements on the sides of the link/button?', 'ct-sgp') ?></small>
                </div>
            </div>
        </div>
        <div>
            <div class="sg-single-setting">
                <div class="sg-single-setting__label">
                    <label><?php _e('Button class:', 'ct-sgp') ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <select name="size_guide_settings[wc_size_guide_button_class_dropdown]" class="chosen_select"
                            id="wc_size_guide_button_class_dropdown">
                        <option value="global"
                            <?php $this->getSelected($post_id, 'wc_size_guide_button_class_dropdown', 'global') ?>><?php _e('Use
                        global settings', 'ct-sgp') ?></option>
                        <option value="individual_class"
                            <?php $this->getSelected($post_id, 'wc_size_guide_button_class_dropdown', 'individual_class') ?>>
                            ' .
                            __('Use individual settings', 'ct-sgp') ?>
                        </option>
                    </select>
                    <small><?php _e("Chose whether to use global or individual option to set custom class of the size guide
                        button.", 'ct-sgp') ?></small>
                </div>
                <script>
                    (function ($) {
                        'use strict';
                        $(document).ready(function () {

                            $("#wc_size_guide_button_class_dropdown option:selected").each(function () {
                                var selected = $(this).val();
                                if (selected == 'individual_class') {
                                    $("#individual_class_chosen").css({"display": "block"});
                                    var input = $("#individual_class").val();
                                    if (input == 'global') {
                                        $("#individual_class").val('');
                                    }

                                } else {
                                    $("#individual_class_chosen").css({"display": "none"});
                                    $("#individual_class").val('global');
                                }
                            });

                            $("#wc_size_guide_button_class_dropdown").change(function () {
                                var selected = $(this).val();
                                if (selected == 'individual_class') {
                                    $("#individual_class_chosen").css({"display": "block"});
                                    var input = $("#individual_class").val();
                                    if (input == 'global') {
                                        $("#individual_class").val('');
                                    }
                                } else {
                                    $("#individual_class_chosen").css({"display": "none"});
                                    $("#individual_class").val('global');
                                }
                            });
                        });
                    }(jQuery));
                </script>

            </div>
        </div>
        <div>
            <div class="sg-single-setting" id="individual_class_chosen" style="display:none">
                <div class="sg-single-setting__label">
                    <label><?php _e('Individual class:', 'ct-sgp') ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <input type="text" name="size_guide_settings[wc_size_guide_button_class]"
                           value="<?php $this->getNumberValue($post_id, 'wc_size_guide_button_class', 'global') ?>"
                           class="chosen_input" id="individual_class">
                    <small><?php _e('Add a custom class to the button. Default class which we use is button_sg', 'ct-sgp') ?> </small>
                </div>
            </div>
        </div>
        <div>
            <div class="sg-single-setting">
                <div class="sg-single-setting__label">
                    <label><?php _e('Margins of the link/button:', 'ct-sgp') ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <select name="size_guide_settings[wc_size_guide_button_margins_dropdown]" class="chosen_select"
                            id="wc_size_guide_button_margins_dropdown">
                        <option value="global"
                            <?php $this->getSelected($post_id, 'wc_size_guide_button_margins_dropdown', 'global') ?>><?php _e('Use
                    global settings', 'ct-sgp') ?></option>
                        <option value="individual_margins"
                            <?php $this->getSelected($post_id, 'wc_size_guide_button_margins_dropdown', 'individual_margins') ?>><?php _e('Use individual settings', 'ct-sgp') ?></option>
                    </select>
                    <small><?php _e("Chose whether to use global or individual option to set button/link margins.", 'ct-sgp')
                        ?></small>
                </div>
                <script>
                    (function ($) {
                        'use strict';
                        $(document).ready(function () {

                            $("#wc_size_guide_button_margins_dropdown option:selected").each(function () {
                                var selected = $(this).val();
                                if (selected == 'individual_margins') {
                                    $("#individual_margins_chosen").css({"display": "block"});
                                    var input_left = $("#individual_margins_left").val();

                                    if (input_left == 'global') {
                                        $("#individual_margins_left").val('');
                                        $("#individual_margins_top").val('');
                                        $("#individual_margins_right").val('');
                                        $("#individual_margins_bottom").val('');
                                    }
                                } else {
                                    $("#individual_margins_chosen").css({"display": "none"});
                                    $("#individual_margins_left").val('global');
                                    $("#individual_margins_top").val('global');
                                    $("#individual_margins_right").val('global');
                                    $("#individual_margins_bottom").val('global');
                                }
                            });

                            $("#wc_size_guide_button_margins_dropdown").change(function () {
                                var selected = $(this).val();

                                if (selected == 'individual_margins') {
                                    $("#individual_margins_chosen").css({"display": "block"});
                                    var input_left = $("#individual_margin_left").val();
                                    if (input_left == 'global') {
                                        $("#individual_margin_left").val('');
                                        $("#individual_margin_top").val('');
                                        $("#individual_margin_right").val('');
                                        $("#individual_margin_bottom").val('');
                                    }
                                } else {
                                    $("#individual_margins_chosen").css({"display": "none"});
                                    $("#individual_margin_left").val('global');
                                    $("#individual_margin_top").val('global');
                                    $("#individual_margin_right").val('global');
                                    $("#individual_margin_bottom").val('global');
                                }
                            });
                        });
                    }(jQuery));
                </script>
                <div class="sg-single-setting" id="individual_margins_chosen" style="display:none">

                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_button_margin_left', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_button_margin_left]"
                                                        class="chosen_input" id="individual_margin_left"
                                                        placeholder="0"><span><?php _e('Margin left', 'ct-sgp') ?></span>
                    </div>
                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_button_margin_top', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_button_margin_top]"
                                                        class="chosen_input" id="individual_margin_top"
                                                        placeholder="0"><span><?php _e('Margin top', 'ct-sgp') ?></span>
                    </div>
                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_button_margin_right', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_button_margin_right]"
                                                        class="chosen_input" id="individual_margin_right"
                                                        placeholder="0"><span><?php _e('Margin right', 'ct-sgp') ?></span>
                    </div>
                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_button_margin_bottom', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_button_margin_bottom]"
                                                        class="chosen_input" id="individual_margin_bottom"
                                                        placeholder="0"><span><?php _e('Margin bottom', 'ct-sgp') ?></span>
                    </div>
                    <div>&nbsp;</div>
                </div>
            </div>
        </div>
        <div>
            <div class="sg-single-setting">
                <?php
                //If there is not changed color, it takes global color which is black.
                $globalColor = new ctSizeGuideSettings();
                $globalColor = $globalColor->wcSizeGuidePopupOverlayColorGlobal();
                ?>
                <div class="sg-single-setting__label">
                    <label><?php _e('Popup overlay color:', 'ct-sgp') ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <input type="text" name="size_guide_settings[wc_size_guide_overlay_color]" class="ct-sg-color"
                           value="<?php $this->getNumberValue($post_id, 'wc_size_guide_overlay_color', $globalColor) ?>"><small><?php _e('Click to pick the color of the popup background overlay. Get global option by clicking clear and update', 'ct-sgp') ?></small>
                </div>
            </div>
        </div>
        <div>
            <div class="sg-single-setting">
                <div class="sg-single-setting__label">
                    <label><?php _e('Popup window content paddings:', 'ct-sgp') ?></label>
                </div>
                <div class="sg-single-setting__wrap">
                    <select name="size_guide_settings[wc_size_guide_modal_padding_dropdown]" class="chosen_select"
                            id="wc_size_guide_modal_padding_dropdown">
                        <option value="global" <?php $this->getSelected($post_id, 'wc_size_guide_modal_padding_dropdown', 'global') ?>><?php _e('Use global settings', 'ct-sgp') ?></option>
                        <option value="individual_paddings" <?php $this->getSelected($post_id, 'wc_size_guide_modal_padding_dropdown', 'individual_paddings') ?>><?php _e('Use individual settings', 'ct-sgp') ?></option>
                    </select>
                    <small><?php _e("Chose whether to use global or individual option to set popup window content paddings.", 'ct-sgp') ?></small>
                </div>
                <script>
                    (function ($) {
                        'use strict';
                        $(document).ready(function () {

                            $("#wc_size_guide_modal_padding_dropdown option:selected").each(function () {
                                var selected = $(this).val();
                                if (selected == 'individual_paddings') {
                                    $("#individual_paddings_chosen").css({"display": "block"});
                                    var input_left;
                                    input_left = $("#individual_padding_left").val();
                                    if (input_left == 'global') {
                                        $("#individual_padding_left").val('');
                                        $("#individual_padding_top").val('');
                                        $("#individual_padding_right").val('');
                                        $("#individual_padding_bottom").val('');
                                    }
                                } else {
                                    $("#individual_paddings_chosen").css({"display": "none"});
                                    $("#individual_padding_left").val('global');
                                    $("#individual_padding_top").val('global');
                                    $("#individual_padding_right").val('global');
                                    $("#individual_padding_bottom").val('global');
                                }
                            });

                            $("#wc_size_guide_modal_padding_dropdown").change(function () {
                                var selected = $(this).val();

                                if (selected == 'individual_paddings') {
                                    $("#individual_paddings_chosen").css({"display": "block"});
                                    var input_left;
                                    input_left = $("#individual_padding_left").val();
                                    if (input_left == 'global') {
                                        $("#individual_padding_left").val('');
                                        $("#individual_padding_top").val('');
                                        $("#individual_padding_right").val('');
                                        $("#individual_padding_bottom").val('');
                                    }
                                } else {
                                    $("#individual_paddings_chosen").css({"display": "none"});
                                    $("#individual_padding_left").val('global');
                                    $("#individual_padding_top").val('global');
                                    $("#individual_padding_right").val('global');
                                    $("#individual_padding_bottom").val('global');
                                }
                            });
                        });
                    }(jQuery));
                </script>

                <div class="sg-single-setting" id="individual_paddings_chosen" style="display:none">
                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_modal_padding_left', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_modal_padding_left]"
                                                        class="chosen_input"
                                                        id="individual_padding_left"><span><?php _e('Padding left', 'ct-sgp') ?></span>
                    </div>
                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_modal_padding_top', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_modal_padding_top]"
                                                        class="chosen_input"
                                                        id="individual_padding_top"><span><?php _e('Padding top', 'ct-sgp') ?></span>
                    </div>
                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_modal_padding_right', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_modal_padding_right]"
                                                        class="chosen_input"
                                                        id="individual_padding_right"><span><?php _e('Padding right', 'ct-sgp') ?></span>
                    </div>
                    <div class="ct-number-input"><input type="text"
                                                        value="<?php $this->getNumberValue($post_id, 'wc_size_guide_modal_padding_bottom', 'global') ?>"
                                                        name="size_guide_settings[wc_size_guide_modal_padding_bottom]"
                                                        class="chosen_input"
                                                        id="individual_padding_bottom"><span><?php _e('Padding bottom', 'ct-sgp') ?></span>
                    </div>
                    <div>&nbsp;</div>
                </div>

            </div>
        </div>
        <?php
    }

    /**
     * Gets the post - size guide's settings input values if there was selected individual option. If the post - size guide, is a new one, then it takes values from global options
     * @param $id - post/size guide's id
     * @param $opt - key name - option
     * @param string $default - default value - now it is global option from Woocommerce Settings
     * @return mixed|string|void
     */

    protected function getNumberValue($id, $opt, $default = 'null')
    {
        if ($id != 'new') {
            $val = get_post_meta($id, '_ct_sizeguidesettings');
            if ($val === '' || !isset($val[0])) {           //If settings are empty or are not set, every option takes global value
                $val = get_option($opt, $default);
            } else {                                        //Option takes inputed value
                $val = $val[0];
                $val = $val[$opt];

                if ($val == "" || !isset($val)) {
                    $val = $default;
                    if ($default == 'global') {
                        $val = get_option($opt, $default);
                    }
                }
            }
        } else {                                            //If it's new post - size guide, it takes default value
            $val = get_option($opt, $default);
        }

        return $val;
    }

    /**
     * Gets the post - size guide's settings. Checkes whether selected options of size guides are global or individual.
     * @param $id - post/size guide's id
     * @param $opt - key name - option
     * @param $val - value of selected option
     * @return string - 'selected="selected"' or empty string
     */

    protected function getSelected($id, $opt, $val)
    {
        $selected = ''; //Default $selected is empty
        if ($id != 'new') {
            $a = get_post_meta($id, '_ct_sizeguidesettings');
            if (!isset($a[0])) { //If there is no value in key, it returns empty string
                return '';
            }
            $a = $a[0];
            @$a = $a[$opt]; //$a[0][$opt] ex. a[0]['wc_size_guide_button_label'] => string 'Size Guide' or 'global'

            if ($a == $val) { //If $a ex. 'wc_size_guide_button_label' == third value from called method, means that this option is selected
                $selected = 'selected="selected"';
            }

        } else { //If it is new post - size guide, checks whether third value from called method == 'global', if yes, means that this option is selected
            if ($val == 'global') {
                $selected = 'selected="selected"';
            }
        }
        return $selected;
    }

    /**
     * Store data
     *
     * @param $post_id
     */

    public function saveSizeGuideTable($post_id)
    {
        if (!isset($_POST['size_guide_meta_box_nonce']) || !isset($_POST['size_guide_settings_meta_box_nonce'])) {
            return;
        }

        if (!wp_verify_nonce($_POST['size_guide_meta_box_nonce'], 'size_guide_meta_box') || !wp_verify_nonce($_POST['size_guide_settings_meta_box_nonce'], 'size_guide_settings_meta_box')) {
            return;
        }

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        if (isset($_POST['size_guide']) && 'page' == $_POST['size_guide']) {

            if (!current_user_can('edit_page', $post_id)) {
                return;
            }

        } else {

            if (!current_user_can('edit_post', $post_id)) {
                return;
            }
        }

        if (!isset($_POST['ct_size_guide'])) {
            return;
        }

        $sizeguide = $_POST['ct_size_guide'];
        $sgsettings = $_POST['size_guide_settings'];

        foreach ($sizeguide as $key => $val) {
            $sizeguide[$key]['table'] = json_decode(stripslashes($sizeguide[$key]['table']));
        }

        update_post_meta($post_id, '_ct_sizeguide', $sizeguide);
        update_post_meta($post_id, '_ct_sizeguidesettings', $sgsettings);
    }

    static function getTabs(int $sizeguide_id)
    {
        $tabs = [];
        $post = get_post($sizeguide_id);
        if (!$post instanceof WP_Post) {
            return $tabs;
        }
        $display = new ctSizeGuideDisplay();
        $content_sections = $display->getContentSections(($post->post_content));
        if (is_array($content_sections)) {
            foreach ($content_sections as $content_section_title => $content_section) {
                $tabs[sanitize_title($content_section_title)] = $content_section_title;
            }
        }
        $size_tabs = get_post_meta($post->ID, '_ct_sizeguide', true);
        if (is_array($size_tabs)) {
            foreach ($size_tabs as $table_id => $size_tab) {
                $tabs[$table_id] = $size_tab['title'];
            }
        }
        return $tabs;
    }

    static function getTabsOrdered($sizeguide_id, $only_values = false)
    {
        $tabs_order = [];
        if (!is_numeric($sizeguide_id)) {
            return $tabs_order;
        }
        $settings = get_post_meta($sizeguide_id, '_ct_sizeguidesettings', true);
        $tabs_order_settings = (isset($settings['wc_size_guide_tabs_order'])) ? $settings['wc_size_guide_tabs_order'] : "";
        $all_tabs = self::getTabs($sizeguide_id);

        if (!empty($tabs_order_settings)) {
            $tabs_order_settings = explode(';', $tabs_order_settings);
            foreach ($tabs_order_settings as $tabs_order_setting) {
                if (!array_key_exists($tabs_order_setting, $all_tabs)) {
                    continue;
                }
                $current_tab = $all_tabs[$tabs_order_setting];
                unset($all_tabs[$tabs_order_setting]);
                $tabs_order[$tabs_order_setting] = $current_tab;
            }
        }
        $tabs_order = array_merge($tabs_order, $all_tabs);

        if ($only_values) {
            return array_keys($tabs_order);
        }

        return $tabs_order;
    }
}

new ctSizeGuideTable();