<?php
/**
 * Kalium WordPress Theme
 *
 * Portfolio archive.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Theme header.
 */
get_header();

/**
 * Hook: kalium_portfolio_archive_before_content.
 *
 * @hooked kalium_portfolio_init_query - 0
 * @hooked kalium_portfolio_archive_wrapper_start - 10
 */
do_action( 'kalium_portfolio_archive_before_content' );

/**
 * Hook: kalium_portfolio_archive_content.
 *
 * @hooked kalium_content_wrapper_main_content_start - 10
 * @hooked kalium_portfolio_loop_heading - 20
 * @hooked kalium_portfolio_items_loop - 30
 * @hooked kalium_portfolio_items_pagination - 40
 * @hooked kalium_content_wrapper_main_content_end - 999
 */
do_action( 'kalium_portfolio_archive_content' );

/**
 * Hook: kalium_blog_archive_after_content.
 *
 * @hooked kalium_portfolio_archive_wrapper_end - 100
 */
do_action( 'kalium_portfolio_archive_after_content' );

/**
 * Theme footer.
 */
get_footer();
