! ( function () {
	function countdown( element, options ) {
		// Default settings
		var settings = {
			date: null,
			format: 'off', // Changed to 'off' by default for performance
		};

		// Merge options
		for ( var prop in options ) {
			if ( options.hasOwnProperty( prop ) ) {
				settings[ prop ] = options[ prop ];
			}
		}

		// Get references
		var daysElement = element.querySelector( '.days' );
		var hoursElement = element.querySelector( '.hours' );
		var minutesElement = element.querySelector( '.minutes' );
		var secondsElement = element.querySelector( '.seconds' );
		var daysTextElement = element.querySelector( '.timeRefDays' );
		var hoursTextElement = element.querySelector( '.timeRefHours' );
		var minutesTextElement = element.querySelector( '.timeRefMinutes' );
		var secondsTextElement = element.querySelector( '.timeRefSeconds' );

		function updateCountdown() {
			var eventDate = new Date( settings.date ).getTime() / 1000;
			var currentDate = Math.floor( Date.now() / 1000 );

			// Check for callback and stop if time is up
			if ( eventDate <= currentDate ) {
				clearInterval( interval );
				return;
			}

			var remaining = Math.max( eventDate - currentDate, 0 ); // Ensure non-negative

			// Calculate time units efficiently using bitwise operators
			var days = Math.floor( remaining / 86400 ); // 60 * 60 * 24
			var hours = Math.floor( ( remaining % 86400 ) / 3600 ); // remaining / (60 * 60)
			var minutes = Math.floor( ( ( remaining % 86400 ) % 3600 ) / 60 ); // remaining / 60
			var seconds = remaining % 60;

			// Update text for singular units only once
			daysTextElement.textContent =
				days === 1
					? daysTextElement.dataset.textSingular
					: daysTextElement.dataset.text;
			hoursTextElement.textContent =
				hours === 1
					? hoursTextElement.dataset.textSingular
					: hoursTextElement.dataset.text;
			minutesTextElement.textContent =
				minutes === 1
					? minutesTextElement.dataset.textSingular
					: minutesTextElement.dataset.text;
			secondsTextElement.textContent =
				seconds === 1
					? secondsTextElement.dataset.textSingular
					: secondsTextElement.dataset.text;

			// Update display with two digits if format is set
			if ( settings.format === 'on' ) {
				function pad( value ) {
					return value.toString().padStart( 2, '0' );
				}
				daysElement.textContent = pad( days );
				hoursElement.textContent = pad( hours );
				minutesElement.textContent = pad( minutes );
				secondsElement.textContent = pad( seconds );
			} else {
				daysElement.textContent = days;
				hoursElement.textContent = hours;
				minutesElement.textContent = minutes;
				secondsElement.textContent = seconds;
			}
		}

		updateCountdown();
		var interval = setInterval( updateCountdown, 1000 );
	}

	// Initialize
	document.addEventListener( 'DOMContentLoaded', function () {
		document.querySelectorAll( '.countdown' ).forEach( function ( el ) {
			countdown( el, {
				date: el.dataset.date,
				format: 'on',
			} );
		} );
	} );
} )();
