<?php
/**
 * Kalium WordPress Theme
 *
 * Starter sites page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */

use Kalium\Admin\Dashboard;
use Kalium\Importer\Importer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
?>
<div class="kalium-sites__top-bar">
	<div class="kalium-sites__top-bar__content">
		<a href="<?php echo esc_url( Dashboard::tab_link( 'system-status' ) ); ?>" class="button">Check your System Status</a>
		<a href="https://docs.kaliumtheme.com/getting-started/installation/importing-a-starter-site" target="_blank" rel="noreferrer noopener" class="button button-primary">Read more</a>
	</div>

	<div class="kalium-sites__top-bar__content kalium-sites__top-bar__content--right">
		<?php Importer::instance()->starter_sites_types_dropdown(); ?>
	</div>
</div>
<?php
/**
 * Starter sites
 */
Importer::instance()->list_starter_sites();
