<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control extender.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Base_Control extends \WP_Customize_Control {

	/**
	 * Control class name.
	 *
	 * @var string
	 */
	protected $control_class_name = 'kalium-customize-control';

	/**
	 * Classes.
	 *
	 * @var string[]
	 */
	public $control_classes = [];

	/**
	 * Heading title.
	 *
	 * @var string
	 */
	public $heading_title;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = true;

	/**
	 * Input style.
	 *
	 * @var string
	 */
	public $input_style;

	/**
	 * Separator line.
	 *
	 * @var bool
	 */
	public $separator;

	/**
	 * Separator type.
	 *
	 * @var int
	 */
	public $separator_type = 1;

	/**
	 * Reset value.
	 *
	 * @var bool
	 */
	public $reset;

	/**
	 * Responsive.
	 *
	 * @var bool
	 */
	public $responsive;

	/**
	 * Responsive disable devices.
	 *
	 * @var array
	 */
	public $responsive_disable = [];

	/**
	 * Choices fallback.
	 *
	 * @var string|array
	 */
	public $choices_fallback;

	/**
	 * Help text.
	 *
	 * @var string
	 */
	public $help;

	/**
	 * Dependencies.
	 *
	 * @var array
	 */
	public $dependency = [];

	/**
	 * Contextual.
	 *
	 * @var bool
	 */
	public $contextual;

	/**
	 * Search keywords to make control easily to find.
	 *
	 * @var array|string
	 */
	public $tags;

	/**
	 * JS callback when setting value is updated.
	 *
	 * Transport mode for the setting needs to be postMessage for this to work.
	 *
	 * @var string
	 */
	public $update_js_callback;

	/**
	 * Content to print when the setting is updated.
	 *
	 * Transport mode for the setting needs to be postMessage for this to work.
	 *
	 * @var string
	 */
	public $update_print;

	/**
	 * Alias of $update_print which wraps into <style>.
	 *
	 * @var string
	 */
	public $update_css;

	/**
	 * Enqueue control related scripts/styles.
	 */
	public function enqueue() {
		kalium_enqueue( 'theme-customizer' );
	}

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		// Update print
		$update_print = $this->update_print;

		// Update print with style wrap
		if ( ! empty( $this->update_css ) ) {
			$update_print = sprintf( '<style>%s</style>', $this->update_css );
		}

		// JSON vars
		$this->json['control_class_name'] = $this->control_class_name;
		$this->json['control_classes']    = $this->control_classes;
		$this->json['heading_title']      = $this->heading_title;
		$this->json['inline_label']       = $this->inline_label;
		$this->json['input_style']        = $this->input_style;
		$this->json['separator']          = $this->separator;
		$this->json['separator_type']     = $this->separator_type;
		$this->json['reset']              = $this->reset;
		$this->json['default_value']      = $this->setting->default;
		$this->json['responsive']         = $this->responsive;
		$this->json['responsive_disable'] = is_string( $this->responsive_disable ) ? explode( ',', $this->responsive_disable ) : $this->responsive_disable;
		$this->json['help']               = $this->help;
		$this->json['dependency']         = $this->dependency;
		$this->json['update_js_callback'] = $this->update_js_callback;
		$this->json['update_print']       = $update_print;
		$this->json['choices']            = is_callable( $this->choices ) ? call_user_func( $this->choices, $this ) : $this->choices;
		$this->json['choices_fallback']   = $this->choices_fallback;
		$this->json['contextual']         = $this->contextual;
		$this->json['tags']               = $this->tags;
	}

	/**
	 * Add control class.
	 *
	 * @param string $class_name
	 */
	public function add_class( $class_name ) {
		$this->control_classes[] = $class_name;
	}

	/**
	 * Remove control class.
	 *
	 * @param string $class_name
	 */
	public function remove_class( $class_name ) {
		if ( $index = array_search( $class_name, $this->control_classes ) ) { // @codingStandardsIgnoreLine
			unset( $this->control_classes[ $index ] );
		}
	}

	/**
	 * Control wrapper start.
	 */
	public function control_wrapper_start() {
		?>
		<#
		var className = '<?php echo esc_attr( $this->control_class_name ); ?>';
		var classes = [
		className,
		className + '--<?php echo esc_attr( $this->type ); ?>',
		].concat( data.control_classes );
		if ( data.inline_label ) {
		classes.push( className + '--inline-label' );
		}
		#>
		<div class="{{ classes.join( ' ' ) }}">
		<# if ( data.separator ) { #>
		<div class="{{ className }}__separator {{ className }}__separator--type-{{ data.separator_type }}"></div>
		<# } #>
		<# if ( data.heading_title ) { #>
		<div class="{{ className }}__heading-title">{{ data.heading_title }}</div>
		<# } #>
		<div class="{{ className }}__label-input-wrapper">
		<# if ( data.label ) { #>
		<div class="{{ className }}__label">
		<span class="customize-control-title">{{{ data.label }}}</span>
		<# if ( data.responsive ) { #>
		<div class="{{ className }}__responsive-controls"></div>
		<# } #>
		<# if ( data.reset ) { #>
		<a href="#" class="{{ className }}__reset" title="Reset">Reset</a>
		<# } #>
		</div>
		<# } #>
		<?php
	}

	/**
	 * Control input wrapper start.
	 */
	public function control_input_wrapper_start() {
		?>
		<#
		var className = '<?php echo esc_attr( $this->control_class_name ); ?>';
		#>
		<div class="{{ className }}__input"<# if ( data.input_style ) { #> style="{{{ data.input_style }}}"<# } #>>
		<?php
	}

	/**
	 * Control input wrapper end.
	 */
	public function control_input_wrapper_end() {
		?>
		</div><!-- input -->
		<?php
	}

	/**
	 * Control wrapper end.
	 */
	public function control_wrapper_end() {
		?>
		</div><!-- label-input-wrapper -->

        <# if ( data.description ) { #>
		<span class="customize-control-description">{{{ data.description }}}</span>
		<# } #>
		</div><!-- wrapper -->
		<?php
	}

	/**
	 * Input template render.
	 */
	public function control_input() {
		printf( '<div class="%s__input-container">...</div>', esc_attr( $this->control_class_name ) );
	}

	/**
	 * Render JS template for input.
	 */
	public function content_template() {

		// Wrapper start
		$this->control_wrapper_start();

		// Input wrapper start
		$this->control_input_wrapper_start();

		// Control input
		$this->control_input();

		// Input wrapper end
		$this->control_input_wrapper_end();

		// Wrapper end
		$this->control_wrapper_end();
	}
}
