<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Border Control.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Border extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-border';

	/**
	 * Compact mode.
	 *
	 * @var bool
	 */
	public $compact = false;

	/**
	 * With slider.
	 *
	 * @var bool
	 */
	public $slider = false;

	/**
	 * Border style.
	 *
	 * @var bool
	 */
	public $border_style = false;

	/**
	 * Color picker.
	 *
	 * @var bool
	 */
	public $color_picker = true;

	/**
	 * Enable alpha in color.
	 *
	 * @var bool
	 */
	public $enable_alpha = true;

	/**
	 * Show predefined colors.
	 *
	 * @var bool
	 */
	public $base_colors = true;

	/**
	 * Disable units.
	 *
	 * @var bool
	 */
	public $disable_units = false;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['compact']       = $this->compact;
		$this->json['slider']        = $this->slider;
		$this->json['border_style']  = $this->border_style;
		$this->json['color_picker']  = $this->color_picker;
		$this->json['enable_alpha']  = $this->enable_alpha;
		$this->json['base_colors']   = $this->base_colors;
		$this->json['disable_units'] = $this->disable_units;
	}
}
