<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Options Import.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Options_Import extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-options-import';

	/**
	 * Contextual.
	 *
	 * @var bool
	 */
	public $contextual = true;

	/**
	 * Select file text.
	 *
	 * @var string
	 */
	public $select_text;

	/**
	 * Button text.
	 *
	 * @var string
	 */
	public $button_text;

	/**
	 * Invalid mime text.
	 *
	 * @var string
	 */
	public $invalid_mime_text;

	/**
	 * Invalid export type text.
	 *
	 * @var string
	 */
	public $invalid_type_text;

	/**
	 * Import failed text.
	 *
	 * @var string
	 */
	public $import_failed_text;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['select_text']        = $this->select_text;
		$this->json['button_text']        = $this->button_text;
		$this->json['invalid_mime_text']  = $this->invalid_mime_text;
		$this->json['invalid_type_text']  = $this->invalid_type_text;
		$this->json['import_failed_text'] = $this->import_failed_text;
	}
}
