<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Range.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Range extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-range';

	/**
	 * Min.
	 *
	 * @var int
	 */
	public $min;

	/**
	 * Max.
	 *
	 * @var int
	 */
	public $max;

	/**
	 * Step.
	 *
	 * @var int
	 */
	public $step;

	/**
	 * Slider min.
	 *
	 * @var int
	 */
	public $slider_min;

	/**
	 * Slider max.
	 *
	 * @var int
	 */
	public $slider_max;

	/**
	 * Slider step.
	 *
	 * @var int
	 */
	public $slider_step;

	/**
	 * Initial position of the range.
	 *
	 * @var int
	 */
	public $initial_position;

	/**
	 * Marks.
	 *
	 * @var bool|array
	 */
	public $marks;

	/**
	 * Show tooltip.
	 *
	 * @var bool
	 */
	public $show_tooltip;

	/**
	 * With input field.
	 *
	 * Determines if the input number field will render next to the RangeControl.
	 * This is overridden to false when step is set to the special string value any.
	 *
	 * @var bool
	 */
	public $with_input_field = true;

	/**
	 * Units.
	 *
	 * @var array
	 */
	public $units;

	/**
	 * Prefix.
	 *
	 * @var string
	 */
	public $prefix;

	/**
	 * Suffix.
	 *
	 * @var string
	 */
	public $suffix;

	/**
	 * Placeholder.
	 *
	 * @var string
	 */
	public $placeholder;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Tooltip content.
	 *
	 * @var array
	 */
	public $tooltip_content;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['min']              = $this->min;
		$this->json['max']              = $this->max;
		$this->json['step']             = $this->step;
		$this->json['slider_min']       = $this->slider_min;
		$this->json['slider_max']       = $this->slider_max;
		$this->json['slider_step']      = $this->slider_step;
		$this->json['initial_position'] = $this->initial_position;
		$this->json['marks']            = $this->marks;
		$this->json['show_tooltip']     = $this->show_tooltip;
		$this->json['with_input_field'] = $this->with_input_field;
		$this->json['units']            = $this->units;
		$this->json['prefix']           = $this->prefix;
		$this->json['suffix']           = $this->suffix;
		$this->json['placeholder']      = $this->placeholder;
		$this->json['tooltip_content']  = $this->tooltip_content;
	}
}
