<?php
/**
 * Kalium WordPress Theme
 *
 * Theme section that can be nested.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Section_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Base_Section extends \WP_Customize_Section {

	/**
	 * Section type.
	 *
	 * @var string
	 */
	public $type = 'kalium-section';

	/**
	 * Parent section.
	 *
	 * @var string
	 */
	public $parent_section;

	/**
	 * URL to show when navigating to the section.
	 *
	 * @var string
	 */
	public $active_url;

	/**
	 * Section link.
	 *
	 * @var string
	 */
	public $href;

	/**
	 * Preview viewport.
	 *
	 * @var string
	 */
	public $viewport;

	/**
	 * Section icon.
	 *
	 * @var string
	 */
	public $icon;

	/**
	 * Section path.
	 *
	 * @param string $section_id
	 * @param array  $path
	 *
	 * @return array
	 */
	public function get_section_path( $section_id, &$path = [] ) {
		if ( $section_id ) {
			$parent_section = $this->manager->get_section( $section_id );

			// Search within panel sections
			if ( ! $parent_section ) {
				global $wp_customize;

				$panels = $wp_customize->panels();

				while ( $panel = array_shift( $panels ) ) {
					if ( isset( $panel->sections[ $section_id ] ) ) {
						$parent_section = $panel->sections[ $section_id ];
						break;
					}
				}
			}

			if ( $parent_section ) {
				array_unshift( $path, $parent_section->title );

				// Panel parent
				if ( $parent_section->panel ) {
					array_unshift( $path, $wp_customize->get_panel( $parent_section->panel )->title );
				}

				// Section parent
				if ( isset( $parent_section->parent_section ) ) {
					$this->get_section_path( $parent_section->parent_section, $path );
				}
			}
		}

		return $path;
	}

	/**
	 * To JSON.
	 *
	 * @return array
	 */
	public function json() {
		return array_merge(
			parent::json(),
			[
				'parent_section' => $this->parent_section,
				'active_url'     => $this->active_url,
				'href'           => $this->href,
				'viewport'       => $this->viewport,
				'icon'           => $this->icon,
				'section_path'   => $this->get_section_path( $this->parent_section ),
			]
		);
	}
}
