<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Section Group.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Section_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Section_Group extends Base_Section {

	/**
	 * Section type.
	 *
	 * @var string
	 */
	public $type = 'kalium-section-group';

	/**
	 * Separator line.
	 *
	 * @var bool
	 */
	public $separator = true;

	/**
	 * To JSON.
	 *
	 * @return array
	 */
	public function json() {
		return array_merge(
			parent::json(),
			[
				'separator' => $this->separator,
			]
		);
	}
}
