<?php
/**
 * Element Visibility settings groups.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Settings_Groups;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

trait Element_Visibility {

	/**
	 * Visible on setting.
	 *
	 * @param string $namespace
	 * @param array  $args
	 */
	public function register_visibility_setting( $namespace, $args = [] ) {
		$settings = $this->get_prefixed_settings(
			$namespace,
			[
				'visibility',
			]
		);

		$this->add_control(
			$settings['visibility'],
			array_merge(
				[
					'type'          => 'kalium-checkbox-button',
					'heading_title' => 'Responsive',
					'label'         => 'Visible On',
					'separator'     => true,
					'reset'         => true,
					'inline_label'  => false,
					'choices'       => [
						'desktop' => [
							'label' => 'Desktop',
							'icon'  => 'desktop',
						],
						'tablet'  => [
							'label' => 'Tablet',
							'icon'  => 'tablet',
						],
						'mobile'  => [
							'label' => 'Mobile',
							'icon'  => 'mobile',
						],
					],
					'default'       => [
						'desktop',
						'tablet',
						'mobile',
					],
					'setting'       => [
						'transport' => 'postMessage',
					],
				],
				$args
			)
		);
	}
}
