<?php
/**
 * Pagination settings groups.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Settings_Groups;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

trait Pagination {

	/**
	 * Get pagination settings.
	 *
	 * @param string $namespace
	 *
	 * @return array
	 */
	public function get_pagination_settings( $namespace ) {
		return array_map(
			'kalium_get_theme_option',
			$this->get_prefixed_settings(
				$namespace,
				[
					'type',
					'numbers_display',
					'infinite_scroll_auto_reveal',
					'infinite_scroll_loading_effect',
					'align',
				]
			)
		);
	}
}
