<?php
/**
 * Kalium WordPress Theme
 *
 * Blog template hooks.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Blog page header.
 */
add_action( 'wp_head', 'kalium_blog_page_header' );

/**
 * Blog archive wrapper.
 */
add_action( 'kalium_blog_archive_before_content', 'kalium_blog_archive_wrapper_start' );
add_action( 'kalium_blog_archive_after_content', 'kalium_blog_archive_wrapper_end', 100 );

/**
 * Blog archive after content.
 */
add_action( 'kalium_blog_archive_after_content', 'kalium_blog_sidebar_loop' );
add_action( 'kalium_blog_archive_after_content', 'kalium_reset_blog_options', 1000 );

/**
 * Blog loop before post item.
 */
add_action( 'kalium_blog_loop_post_before', 'kalium_blog_post_thumbnail', 10 );

/**
 * Loop thumbnail hover layer and post format icon.
 */
add_action( 'kalium_blog_loop_after_post_thumbnail', 'kalium_blog_post_hover_layer', 10 );
add_action( 'kalium_blog_loop_after_post_thumbnail', 'kalium_blog_post_format_icon', 20 );

/**
 * Blog archive page.
 */
add_action( 'kalium_blog_archive_content', 'kalium_content_wrapper_main_content_start' );
add_action( 'kalium_blog_archive_content', 'kalium_blog_posts_loop', 20 );
add_action( 'kalium_blog_archive_content', 'kalium_blog_archive_posts_pagination', 30 );
add_action( 'kalium_blog_archive_content', 'kalium_content_wrapper_main_content_end', 999 );

/**
 * No posts to show.
 */
add_action( 'kalium_blog_no_posts_found', 'kalium_blog_no_posts_found_message', 10 );

/**
 * Blog loop post details.
 */
add_action( 'kalium_blog_loop_post_details', 'kalium_blog_post_title', 10 );
add_action( 'kalium_blog_loop_post_details', 'kalium_blog_post_excerpt', 20 );
add_action( 'kalium_blog_loop_post_details', 'kalium_blog_post_meta', 30 );

/**
 * Single post wrapper and sidebar.
 */
add_action( 'kalium_blog_single', 'kalium_blog_single_wrapper_start' );
add_action( 'kalium_blog_single', 'kalium_content_wrapper_main_content_start', 20 );
add_action( 'kalium_blog_single', 'kalium_content_wrapper_main_content_end', 70 );
add_action( 'kalium_blog_single', 'kalium_blog_single_post_sidebar', 80 );
add_action( 'kalium_blog_single', 'kalium_blog_single_wrapper_end', 90 );

/**
 * Single post content.
 */
add_action( 'kalium_blog_single', 'kalium_blog_single_content', 30 );

/**
 * Single post after.
 */
add_action( 'kalium_blog_single', 'kalium_blog_single_post_related_posts', 100 );
add_action( 'kalium_blog_single', 'kalium_blog_single_post_comments', 110 );

/**
 * Single post before content.
 */
add_action( 'kalium_blog_single_post_start', 'kalium_blog_single_post_featured_image' );

/**
 * Single post entry-header.
 */
add_action( 'kalium_blog_single_post_header', 'kalium_blog_post_title' );
add_action( 'kalium_blog_single_post_header', 'kalium_blog_post_meta', 20 );

/**
 * Single post entry-content.
 */
add_action( 'kalium_blog_single_post_content', 'kalium_blog_post_content', 10 );

/**
 * Single post entry-footer.
 */
add_action( 'kalium_blog_single_post_footer', 'kalium_blog_single_post_tags_list' );
add_action( 'kalium_blog_single_post_footer', 'kalium_blog_single_post_share_networks', 20 );
add_action( 'kalium_blog_single_post_footer', 'kalium_blog_single_post_author_info', 30 );
add_action( 'kalium_blog_single_post_footer', 'kalium_blog_single_post_navigation', 40 );

/**
 * Post meta entries.
 */
add_action( 'kalium_blog_post_meta', 'kalium_blog_post_date', 10 );
add_action( 'kalium_blog_post_meta', 'kalium_blog_post_category', 20 );

/**
 * Post author description.
 */
add_action( 'kalium_blog_single_post_author_info_details', 'kalium_blog_single_post_author_info_description', 10, 2 );
