<?php
/**
 * Kalium WordPress Theme
 *
 * Portfolio template hooks.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Portfolio wrapper
add_action( 'kalium_portfolio_archive_before_content', 'kalium_portfolio_archive_wrapper_start' );
add_action( 'kalium_portfolio_archive_after_content', 'kalium_portfolio_archive_wrapper_end', 100 );

// Portfolio items
add_action( 'kalium_portfolio_archive_content', 'kalium_content_wrapper_main_content_start' );
add_action( 'kalium_portfolio_archive_content', 'kalium_portfolio_loop_heading', 20 );
add_action( 'kalium_portfolio_archive_content', 'kalium_portfolio_items_loop', 30 );
add_action( 'kalium_portfolio_archive_content', 'kalium_portfolio_items_pagination', 40 );
add_action( 'kalium_portfolio_archive_content', 'kalium_content_wrapper_main_content_end', 999 );

// Loop item type template
add_action( 'kalium_portfolio_loop_item', 'kalium_portfolio_loop_item_type_display' );

// Loop item details
add_action( 'kalium_portfolio_loop_item_details', 'kalium_portfolio_loop_item_title' );
add_action( 'kalium_portfolio_loop_item_details', 'kalium_portfolio_loop_item_subtitle', 20 );

// Featured video
add_action( 'kalium_portfolio_loop_item', 'kalium_portfolio_loop_maybe_display_featured_video', 5 );

// Loop item type 1
add_action( 'kalium_portfolio_loop_item_type-1', 'kalium_portfolio_loop_item_thumbnail' );
add_action( 'kalium_portfolio_loop_item_type-1', 'kalium_portfolio_loop_item_details', 20 );

// Loop item type 1 hover overlay
add_action( 'kalium_portfolio_loop_after_thumbnail', 'kalium_portfolio_loop_item_type_1_thumbnail_overlay' );

// Loop item type 2
add_action( 'kalium_portfolio_loop_item_type-2', 'kalium_portfolio_loop_item_thumbnail' );
add_action( 'kalium_portfolio_loop_item_type-2', 'kalium_portfolio_loop_item_overlay_content', 20 );

// Loop item overlay content
add_action( 'kalium_portfolio_loop_item_overlay_content', 'kalium_portfolio_loop_item_like' );
add_action( 'kalium_portfolio_loop_item_overlay_content', 'kalium_portfolio_loop_item_details', 20 );

// Single portfolio wrapper
add_action( 'kalium_portfolio_single_content_before_content', 'kalium_portfolio_single_wrapper_start' );
add_action( 'kalium_portfolio_single_content_after_content', 'kalium_portfolio_single_wrapper_end', 100 );

// Single item type display
add_action( 'kalium_portfolio_single_content', 'kalium_content_wrapper_main_content_start' );
add_action( 'kalium_portfolio_single_content', 'kalium_portfolio_single_display_item_type', 20 );
add_action( 'kalium_portfolio_single_content', 'kalium_content_wrapper_main_content_end', 999 );

// Single item types
add_action( 'kalium_portfolio_single_item_type-1', 'kalium_portfolio_single_type_side' );
add_action( 'kalium_portfolio_single_item_type-2', 'kalium_portfolio_single_type_columned' );
add_action( 'kalium_portfolio_single_item_type-3', 'kalium_portfolio_single_type_carousel' );
add_action( 'kalium_portfolio_single_item_type-4', 'kalium_portfolio_single_type_zig_zag' );
add_action( 'kalium_portfolio_single_item_type-5', 'kalium_portfolio_single_type_full_screen' );
add_action( 'kalium_portfolio_single_item_type-6', 'kalium_portfolio_single_type_lightbox' );
add_action( 'kalium_portfolio_single_item_type-7', 'kalium_the_content' );

// Side portfolio item
add_action( 'kalium_portfolio_single_type-1_content', 'kalium_portfolio_single_title_and_subtitle' );
add_action( 'kalium_portfolio_single_type-1_content', 'kalium_portfolio_single_entry_content', 20 );
add_action( 'kalium_portfolio_single_type-1_content', 'kalium_portfolio_single_checklist', 20 );
add_action( 'kalium_portfolio_single_type-1_content', 'kalium_portfolio_single_link', 30 );
add_action( 'kalium_portfolio_single_type-1_content', 'kalium_portfolio_single_like_and_share', 40 );

// Columned portfolio item
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_display_featured_image', 5 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_title_and_subtitle' );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_content_services_wrapper_start', 20 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_entry_content', 30 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_services_wrapper_start', 40 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_checklist', 50 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_link', 60 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_services_wrapper_end', 70 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_content_services_wrapper_end', 80 );
add_action( 'kalium_portfolio_single_type-2_content', 'kalium_portfolio_single_like_and_share', 90 );

// Carousel portfolio item
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_title_and_subtitle' );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_content_services_wrapper_start', 20 );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_entry_content', 30 );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_services_wrapper_start', 40 );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_checklist', 50 );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_link', 60 );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_services_wrapper_end', 70 );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_content_services_wrapper_end', 80 );
add_action( 'kalium_portfolio_single_type-3_content', 'kalium_portfolio_single_like_and_share', 90 );

// Zig Zag portfolio item
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_title_and_subtitle' );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_content_services_wrapper_start', 20 );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_entry_content', 30 );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_services_wrapper_start', 40 );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_checklist', 50 );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_link', 60 );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_services_wrapper_end', 70 );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_content_services_wrapper_end', 80 );
add_action( 'kalium_portfolio_single_type-4_content', 'kalium_portfolio_single_like_and_share', 90 );

// Full screen portfolio item
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_content_toggle' );
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_title_and_subtitle', 20 );
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_entry_content', 30 );
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_services_wrapper_start', 40 );
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_checklist', 50 );
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_services_wrapper_end', 60 );
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_link', 70 );
add_action( 'kalium_portfolio_single_type-5_content', 'kalium_portfolio_single_like_and_share', 80 );

// Lightbox portfolio item
add_action( 'kalium_portfolio_single_type-6_content', 'kalium_portfolio_single_title_and_subtitle' );
add_action( 'kalium_portfolio_single_type-6_content', 'kalium_portfolio_single_display_featured_image', 20 );

// Gallery
add_action( 'kalium_portfolio_single_type-1_gallery', 'kalium_portfolio_single_display_gallery_type' );
add_action( 'kalium_portfolio_single_type-2_gallery', 'kalium_portfolio_single_display_gallery_type' );
add_action( 'kalium_portfolio_single_type-3_gallery', 'kalium_portfolio_single_display_gallery_type' );
add_action( 'kalium_portfolio_single_type-4_gallery', 'kalium_portfolio_single_display_gallery_type' );
add_action( 'kalium_portfolio_single_type-5_gallery', 'kalium_portfolio_single_display_gallery_type' );

// Prev-next navigation
add_action( 'kalium_portfolio_single_content', 'kalium_portfolio_single_navigation', 100 );
