<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$disabled_message_text = 'plugin should be installed and activated in order for this element to work.';

$images_url = kalium()->file_url( str_replace( kalium()->locate_file(), '/', __DIR__ . '/images' ) );

return [
	// Elements
	'elements'         => [
		'legacy_header_content_left'                => [
			'extend' => [
				'element' => 'legacy_header_row',
				'title'   => 'Left Content',
			],
		],
		'legacy_header_content_right'               => [
			'extend' => [
				'element'           => 'legacy_header_row',
				'title'             => 'Right Content',
				'extend_attributes' => [
					'align' => [
						'default' => 'right',
					],
				],
			],
		],
		'legacy_header_content_bottom'              => [
			'extend' => [
				'element' => 'legacy_header_row',
				'title'   => 'Bottom Content',
			],
		],
		'legacy_header_menu',
		'legacy_header_menu_trigger',
		'legacy_header_raw_text',
		'legacy_header_search_field',
		'legacy_header_social_icons',
		'legacy_header_button',
		'legacy_header_date_time',
		'legacy_header_woocommerce_my_account_link' => [
			'extend' => [
				'enabled'          => kalium()->is->woocommerce_active(),
				'disabled_message' => 'WooCommerce ' . $disabled_message_text,
			],
		],
		'legacy_header_woocommerce_cart_totals'     => [
			'extend' => [
				'enabled'          => kalium()->is->woocommerce_active(),
				'disabled_message' => 'WooCommerce ' . $disabled_message_text,
			],
		],
		'legacy_header_woocommerce_mini_cart'       => [
			'extend' => [
				'enabled'          => kalium()->is->woocommerce_active(),
				'disabled_message' => 'WooCommerce ' . $disabled_message_text,
			],
		],
		'legacy_header_wpml_language_switcher'      => [
			'extend' => [
				'enabled'          => kalium()->is->wpml_active(),
				'disabled_message' => 'WPML ' . $disabled_message_text,
			],
		],
		'legacy_header_breadcrumb'                  => [
			'extend' => [
				'enabled'          => kalium()->is->breadcrumb_navxt_active(),
				'disabled_message' => 'Breadcrumb NavXT ' . $disabled_message_text,
			],
		],
	],

	// Regions
	'regions'          => [
		'legacy_header_content_left',
		'legacy_header_content_right',
		'legacy_header_content_bottom',
	],

	// Templates
	'templates'        => [
		[
			'id'       => 'custom-header-1',
			'name'     => 'Standard with bottom menu',
			'icon'     => $images_url . '/custom-header-type-1.svg',
			'template' => __DIR__ . '/templates/standard-with-bottom.json',
		],
		[
			'id'       => 'custom-header-2',
			'name'     => 'Centered with side menus',
			'icon'     => $images_url . '/custom-header-type-2.svg',
			'template' => __DIR__ . '/templates/centered-with-side-menus.json',
		],
		[
			'id'       => 'custom-header-3',
			'name'     => 'Centered with side icons',
			'icon'     => $images_url . '/custom-header-type-3.svg',
			'template' => __DIR__ . '/templates/centered-with-side-icons.json',
		],
		[
			'id'       => 'custom-header-4',
			'name'     => 'Standard with combined content',
			'icon'     => $images_url . '/custom-header-type-4.svg',
			'template' => __DIR__ . '/templates/standard-with-combined-content.json',
		],
	],

	// Template columns
	'template_columns' => 2,

	// Tabs
	'tabs'             => [
		'builder'   => [
			'content_type' => 'builder',
			'title'        => 'Builder',
			'description'  => '<h3>Custom Header</h3><p>Create your own header or select any of the pre-made templates.<br /><br /> <small><strong>Please Note:</strong> Template modifications or updates will not take effect unless you publish the changes.</small></p>',
			'active'       => true,
		],
		'templates' => [
			'content_type' => 'templates',
			'title'        => 'Templates',
			'description'  => '<h3>Templates Library</h3><p>Choose from ready to use header templates.</p>',
		],
	],

	// Show attributes on Add Element
	'show_attributes'  => true,
];
