<?php
/**
 * Text element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Element;
use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;

class Text extends Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'text';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Text';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'termDescription';

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Advanced_Layout_Set::class,
				Advanced_Border_Set::class,
				Advanced_Text_Set::class,
				Advanced_Dimensions_Set::class,
				Advanced_Custom_CSS_Set::class,
			]
		);
	}

	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::TAB_CONTENT,
					[
						Attribute::create(
							'content',
							[
								'type'        => 'textarea',
								'title'       => 'Content',
								'description' => 'HTML and shortcodes are supported.',
								'rows'        => 5,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		$content = $this->get_attribute_value( 'content' );

		if ( ! is_null( $content ) ) {
			$content = do_shortcode( wp_kses_post( $content ) );
		}

		if ( ! empty( trim( $content ) ) ) {
			echo kalium_element(
				'div',
				[
					'class' => [
						'links',
					],
				],
				$content
			);
		}
	}
}

// Register element
\Laborator_Builder::register_element_type( Text::class );
