<?php
/**
 * Raw Text element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Raw_Text extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_raw_text';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Text';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'termDescription';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'content',
							[
								'type'        => 'textarea',
								'title'       => 'Content',
								'description' => 'HTML and shortcodes are supported.',
								'rows'        => 5,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		$content = $this->get_attribute_value( 'content' );

		if ( ! is_null( $content ) ) {
			$content = wp_kses_post( $content );
		}

		printf(
			'<div class="%s">%s</div>',
			kalium_tokenize_list(
				[
					'raw-text',
					'links',
				]
			),
			do_shortcode( $content )
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Raw_Text::class );
