<?php
/**
 * Search Field element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Search_Field extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_search_field';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Search Field';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'search';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'align',
							[
								'type'         => 'radio',
								'title'        => 'Search Field Alignment',
								'inline_label' => true,
								'choices'      => [
									'left'  => [
										'icon' => 'justifyLeft',
									],
									'right' => [
										'icon' => 'justifyRight',
									],
								],
								'buttons'      => [
									'icon_size' => 18,
								],
							]
						),
						Attribute::create(
							'input_visibility',
							[
								'type'    => 'radio',
								'title'   => 'Search Field Visibility',
								'choices' => [
									'click'   => 'On click',
									'visible' => 'Always',
								],
								'buttons' => true,
							]
						),
						Attribute::create(
							'icon_animation',
							[
								'type'       => 'radio',
								'title'      => 'Icon Animation',
								'choices'    => [
									'none'  => 'None',
									'shift' => 'Shift',
									'scale' => 'Scale',
								],
								'default'    => 'scale',
								'buttons'    => true,
								'dependency' => [
									'input_visibility' => 'click',
								],
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		kalium_header_search_field(
			[
				'align'            => $this->get_attribute_value( 'align' ),
				'input_visibility' => $this->get_attribute_value( 'input_visibility' ),
				'icon_animation'   => $this->get_attribute_value( 'icon_animation' ),
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Search_Field::class );
