<?php
/**
 * WPML Language Switcher element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_WPML_Language_Switcher extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_wpml_language_switcher';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Language Switcher';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'globe';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'flag',
							[
								'type'         => 'toggle',
								'title'        => 'Show Flag',
								'inline_label' => true,
								'default'      => true,
							]
						),
						Attribute::create(
							'flag_position',
							[
								'type'         => 'radio',
								'title'        => 'Flag Position',
								'inline_label' => true,
								'choices'      => [
									'left'  => [
										'icon' => 'justifyLeft',
									],
									'right' => [
										'icon' => 'justifyRight',
									],
								],
								'buttons'      => [
									'icon_size' => 18,
								],
								'dependency'   => [
									'flag' => true,
								],
							]
						),
						Attribute::create(
							'display_text',
							[
								'type'         => 'toggle',
								'title'        => 'Show Label',
								'inline_label' => true,
								'default'      => true,
							]
						),
						Attribute::create(
							'display_text_format',
							[
								'type'         => 'select',
								'title'        => 'Label Format',
								'inline_label' => true,
								'choices'      => [
									'name'            => 'Native name',
									'translated'      => 'Translated name',
									'initials'        => 'Initials',
									'name-translated' => 'Native name (Translated name)',
									'translated-name' => 'Translated name (Native name)',
								],
								'dependency'   => [
									'display_text' => true,
								],
							]
						),
						Attribute::create(
							'skip_missing',
							[
								'type'         => 'toggle',
								'title'        => 'Skip Missing Translations',
								'inline_label' => true,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		$text_format   = $this->get_attribute_value( 'display_text_format' );
		$flag_position = $this->get_attribute_value( 'flag_position' );
		$skip_missing  = $this->get_attribute_value( 'skip_missing' );

		if ( ! $this->get_attribute_value( 'display_text' ) ) {
			$text_format = 'hide';
		}

		if ( ! $this->get_attribute_value( 'flag' ) ) {
			$flag_position = 'hide';
		}

		$wpml_switcher_args = [
			'flag_position' => $flag_position,
			'display_text'  => $text_format,
			'skip_missing'  => $skip_missing,
		];

		kalium_wpml_language_switcher( $wpml_switcher_args );
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_WPML_Language_Switcher::class );
