<?php
/**
 * WooCommerce Product Category element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Element;
use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Visibility_Hover_Set;
use Laborator_Builder\Attribute_Sets\Product_Common_Attributes_Set;

class WooCommerce_Product_Category extends Element {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'woocommerce_product_category';

	/**
	 * Title.
	 *
	 * @var string
	 */
	public static $title = 'Category';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public static $icon = 'file';

	/**
	 * Maximum instances of element.
	 *
	 * @var int
	 * @static
	 */
	public static $max_instances = 2;

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Advanced_Layout_Set::class,
				Advanced_Visibility_Hover_Set::class,
				Advanced_Border_Set::class,
				Advanced_Text_Set::class,
				Advanced_Dimensions_Set::class,
				Advanced_Custom_CSS_Set::class,
				Product_Common_Attributes_Set::class,
			]
		);
	}

	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'taxonomy',
							[
								'type'         => 'select',
								'title'        => 'Taxonomy',
								'inline_label' => true,
								'choices'      => [
									'category' => 'Categories',
									'tag'      => 'Tags',
								],
							]
						),
						Attribute::create(
							'separator',
							[
								'type'              => 'text',
								'title'             => 'Separator',
								'inline_label'      => true,
								'tooltip'           => 'Visible when there are 2 or more categories',
								'tooltip_placement' => 'top-end',
								'placeholder'       => ', ',
							]
						),
						Attribute::create(
							'text_before',
							[
								'type'         => 'text',
								'title'        => 'Text before',
								'inline_label' => true,
							]
						),
						Attribute::create(
							'text_after',
							[
								'type'         => 'text',
								'title'        => 'Text after',
								'inline_label' => true,
							]
						),
					]
				),
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( WooCommerce_Product_Category::class );
