<?php
/**
 * Product row element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Visibility_Hover_Set;
use Laborator_Builder\Attribute_Sets\Content_Flex_Alignment_Set;
use Laborator_Builder\Attribute_Sets\Content_Visibility_Set;
use Laborator_Builder\Attribute_Sets\Product_Common_Attributes_Set;
use Laborator_Builder\CSS_Value;

class WooCommerce_Product_Row extends Row {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'woocommerce_product_row';

	/**
	 * Allowed child elements.
	 *
	 * @var bool
	 */
	public static $allowed_child_elements = [
		'woocommerce_product_column',
	];

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Advanced_Visibility_Hover_Set::class,
				Product_Common_Attributes_Set::class,
			]
		);
	}

	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Style / Background
				Attribute::tab_section(
					Attribute::TAB_STYLE,
					'Background',
					[
						Attribute::create_tabbed(
							[
								'Normal' => [
									Attribute::create(
										'background_color',
										[
											'type'         => 'color',
											'title'        => 'Background color',
											'inline_label' => true,
											'enable_clear' => true,
											'separator'    => false,
										]
									),
								],
								'Hover'  => [
									Attribute::create(
										'background_color_hover',
										[
											'type'         => 'color',
											'title'        => 'Background color',
											'inline_label' => true,
											'enable_clear' => true,
											'separator'    => false,
										]
									),
								],
							]
						),
					]
				),

				// Style / Links
				Attribute::tab_section(
					Attribute::TAB_STYLE,
					'Links',
					[
						Attribute::create_tabbed(
							[
								'Normal' => [
									Attribute::create(
										'link_color',
										[
											'type'         => 'color',
											'title'        => 'Link color',
											'inline_label' => true,
											'separator'    => false,
										]
									),
								],
								'Hover'  => [
									Attribute::create(
										'link_color_hover',
										[
											'type'         => 'color',
											'title'        => 'Link color',
											'inline_label' => true,
											'separator'    => false,
										]
									),
								],
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		parent::generate_styles();

		$this->add_style(
			[
				// Background color
				'&'       => [
					'background-color' => $this->get_attribute( 'background_color' ),
				],

				// Background color hover
				'&:hover' => [
					'background-color' => $this->get_attribute( 'background_color_hover' ),
				],

				// Link color
				'a'       => [
					'color' => $this->get_attribute( 'link_color' ),
				],

				// Link color hover
				'a:hover' => [
					'color' => $this->get_attribute( 'link_color_hover' ),
				],
			]
		);

		// If its absolute position, stretch the container to the edge
		if ( 'absolute' === $this->get_attribute_value( 'css_position' ) ) {
			$offsets = [
				'left'  => $this->get_style( 'left' ),
				'right' => $this->get_style( 'right' ),
			];

			foreach ( $offsets as $prop => $css_value ) {
				if ( $css_value instanceof CSS_Value && empty( $css_value->value->value() ) ) {
					$this->add_style(
						[
							'&' => [
								$prop => 0,
							],
						]
					);
				}
			}
		}
	}
}

// Register element
\Laborator_Builder::register_element_type( WooCommerce_Product_Row::class );
