<?php
/**
 * Border attributes.
 */

namespace Laborator_Builder\Attribute_Sets;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Set;

class Advanced_Border_Set extends Attribute_Set {

	/**
	 * Get attributes.
	 *
	 * @return array
	 */
	public function get_attributes() {
		return Attribute::tab_section(
			Attribute::TAB_ADVANCED,
			Attribute::SECTION_BORDER,
			[
				Attribute::create(
					'border',
					[
						'type'  => 'border-box',
						'title' => 'Border',
						'reset' => true,
					]
				),
				Attribute::create(
					'border_radius',
					[
						'type'        => 'multi-numeric',
						'title'       => 'Border radius',
						'reset'       => true,
						'value_props' => [
							'top'    => 'Top Left',
							'right'  => 'Top Right',
							'bottom' => 'Bottom Right',
							'left'   => 'Bottom Left',
						],
						'units'       => kalium_get_default_units( 'box-size' ),
						'default'     => [
							'link' => true,
						],
					]
				),
			]
		);
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		$element = $this->get_element();
		$border  = kalium_to_border_box( $element->get_attribute_value( 'border' ) );

		$element->add_style(
			[
				'&' => [
					// Border
					'border-style'  => kalium_get_array_key( $border, 'style' ),
					'border-width'  => kalium_get_array_key( $border, 'width' ),
					'border-color'  => kalium_get_array_key( $border, 'color' ),

					// Border radius
					'border-radius' => [
						'value'  => $element->get_attribute( 'border_radius' ),
						'parser' => 'length',
					],
				],
			]
		);
	}
}
