<?php
/**
 * Text attributes.
 */

namespace Laborator_Builder\Attribute_Sets;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Set;

class Advanced_Text_Set extends Attribute_Set {

	/**
	 * Get attributes.
	 *
	 * @return array
	 */
	public function get_attributes() {
		return Attribute::tab_section(
			Attribute::TAB_ADVANCED,
			Attribute::SECTION_TEXT,
			[
				Attribute::create(
					'font_size',
					[
						'type'         => 'text',
						'title'        => 'Font size',
						'inline_label' => true,
						'responsive'   => true,
						'reset'        => true,
						'units'        => kalium_get_default_units( 'font-size' ),
					]
				),
				Attribute::create(
					'text_align',
					[
						'type'       => 'radio',
						'title'      => 'Text align',
						'responsive' => true,
						'reset'      => true,
						'choices'    => [
							'default' => [
								'label' => 'Default',
								'icon'  => 'globe',
							],
							'start'   => [
								'label' => 'Left',
								'icon'  => 'alignLeft',
							],
							'center'  => [
								'label' => 'Center',
								'icon'  => 'alignCenter',
							],
							'end'     => [
								'label' => 'Right',
								'icon'  => 'alignRight',
							],
						],
						'buttons'    => [
							'icon_size' => 18,
						],
					]
				),
				Attribute::create(
					'text_transform',
					[
						'type'    => 'radio',
						'title'   => 'Text transform',
						'reset'   => true,
						'choices' => [
							'default'    => [
								'label' => 'Default',
								'icon'  => 'globe',
							],
							'uppercase'  => [
								'label' => 'Upper case',
								'icon'  => 'formatUppercase',
							],
							'lowercase'  => [
								'label' => 'Lower case',
								'icon'  => 'formatLowercase',
							],
							'capitalize' => [
								'label' => 'Capitalize',
								'icon'  => 'formatCapitalize',
							],
						],
						'buttons' => [
							'icon_size' => 18,
						],
					]
				),
			]
		);
	}

	/**
	 * Get DOM classes.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$classes = [];
		$element = $this->get_element();

		// Text alignment
		$text_align = $element->get_attribute_value( 'text_align' );

		if ( ! empty( $text_align ) ) {
			$text_align = array_filter(
				$text_align,
				function ( $value ) {
					return 'default' !== $value;
				}
			);

			$classes = array_merge( $classes, kalium_responsive_classname_infix( $text_align, 'text' ) );
		}

		// Text transform
		$text_transform = $element->get_attribute_value( 'text_transform' );

		if ( in_array( $text_transform, [ 'uppercase', 'lowercase', 'capitalize' ] ) ) {
			$classes[] = 'text-' . $text_transform;
		}

		return $classes;
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		$element = $this->get_element();

		$element->add_style(
			[
				// Self
				'&' => [
					'font-size' => $element->get_attribute( 'font_size' ),
				],
			]
		);
	}
}
