<?php
/**
 * Product common attributes.
 */

namespace Laborator_Builder\Attribute_Sets;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Set;

class Product_Common_Attributes_Set extends Attribute_Set {

	/**
	 * Get attributes.
	 *
	 * @return array
	 */
	public function get_attributes() {
		return Attribute::tab_section(
			Attribute::TAB_CONTENT,
			Attribute::SECTION_CONTENT,
			[
				Attribute::create(
					'placement',
					[
						'type'         => 'select',
						'name'         => 'placement',
						'title'        => 'Placement',
						'inline_label' => true,
						'choices'      => [
							'auto'         => 'Auto',
							'top-left'     => 'Top Left',
							'top-right'    => 'Top Right',
							'bottom-left'  => 'Bottom Left',
							'bottom-right' => 'Bottom Right',
						],
						'dependency'   => [
							[
								'type'   => 'element',
								'parent' => 'woocommerce_product_images',
							],
						],
						'order'        => 0,
					]
				),
			]
		);
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$element = $this->get_element();
		$classes = [];

		// Children of WooCommerce Product Images element
		if ( $element->get_parent() && 'woocommerce_product_images' === $element->get_parent()->get_name() && empty( array_intersect( $element->get_attribute_value( 'css_position' ), [ 'absolute', 'relative' ] ) ) ) {
			$placement = $element->get_attribute_value( 'placement' );

			if ( ! empty( $placement ) ) {
				$classes[] = 'placement-inside';
				$classes[] = 'placement-inside--' . $element->get_attribute_value( 'placement' );
			}
		}

		return $classes;
	}
}
