<?php
/**
 * Laborator Builder.
 *
 * Content type template class.
 */

namespace Laborator_Builder;

class Content_Type_Template {

	/**
	 * Template ID.
	 *
	 * @var string
	 */
	public $id;

	/**
	 * Template name.
	 *
	 * @var string
	 */
	public $name;

	/**
	 * Template icon.
	 *
	 * @var string
	 */
	public $icon;

	/**
	 * Template file.
	 *
	 * @var string
	 */
	public $template;

	/**
	 * Initialize.
	 *
	 * @param array $args
	 */
	public function __construct( $args = [] ) {
		$keys = array_keys( get_object_vars( $this ) );

		foreach ( $keys as $key ) {
			if ( isset( $args[ $key ] ) ) {
				$this->{$key} = $args[ $key ];
			}
		}
	}

	/**
	 * Get ID.
	 *
	 * @return string
	 */
	public function get_id() {
		return $this->id;
	}

	/**
	 * Get name/title.
	 *
	 * @return string
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Get icon.
	 *
	 * @return string
	 */
	public function get_icon() {
		return $this->icon;
	}

	/**
	 * Get template.
	 *
	 * @return string
	 */
	public function get_template() {
		return $this->template;
	}

	/**
	 * Get template content.
	 *
	 * @return array|null
	 */
	public function get_template_content() {
		if ( file_exists( $this->get_template() ) ) {
			return json_decode( file_get_contents( $this->get_template() ), true );
		}

		return null;
	}

	/**
	 * Check if template is valid.
	 *
	 * @return bool
	 */
	public function is_valid() {

		// ID is required
		if ( empty( $this->get_id() ) ) {
			return false;
		}

		// Template is required (further checking may be done)
		if ( empty( $this->get_template() ) ) {
			return false;
		}

		return true;
	}

	/**
	 * Export.
	 *
	 * @return array
	 */
	public function export() {
		return [
			'id'               => $this->get_id(),
			'name'             => $this->get_name(),
			'icon'             => $this->get_icon(),
			'template'         => $this->get_template(),
			'template_content' => $this->get_template_content(),
		];
	}
}
