<?php
/**
 * Laborator Builder.
 *
 * Predefined attributes.
 */

namespace Laborator_Builder;

define( 'UNITS_BOX_SIZE', kalium_get_default_units( 'box-size' ) );

class Predefined_Attributes {

	/**
	 * Custom CSS.
	 *
	 * @var array
	 */
	public static $CUSTOM_CSS = [
		'type'        => 'textarea',
		'name'        => 'custom_css',
		'title'       => 'Add your own Custom CSS',
		'description' => 'Use #self to target wrapper element.',
		'code_editor' => [
			'mode'    => 'css',
			'lint'    => false,
			'gutters' => [],
		],
	];

	/**
	 * Border radius.
	 *
	 * @var array
	 */
	public static $BORDER_RADIUS = [
		'type'        => 'multi-numeric',
		'name'        => 'border_radius',
		'title'       => 'Border radius',
		'reset'       => true,
		'value_props' => [
			'top'    => 'Top Left',
			'right'  => 'Top Right',
			'bottom' => 'Bottom Right',
			'left'   => 'Bottom Left',
		],
		'units'       => UNITS_BOX_SIZE,
		'default'     => [
			'link' => true,
		],
	];
}
