<?php
/**
 * TypoLab - ultimate font management library.
 *
 * List of selectors.
 *
 * @author Laborator
 * @link   https://laborator.co
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TypoLab_CSS_Selectors {

	/**
	 * Marks a selector for CSS vars print.
	 *
	 * @const string
	 */
	const TYPE_CSS_VARS = 'css-vars';

	/**
	 * Base selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BASE = [
		'body',
	];

	/**
	 * Sitewide selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SITEWIDE = [
		'body',
	];

	/**
	 * HTML Root.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_ROOT = [
		':root',
	];

	/**
	 * Bold text.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BOLD = [
		'b',
		'strong',
	];

	/**
	 * H1 selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_H1 = [
		'h1',
		'.h1',
	];

	/**
	 * H2 selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_H2 = [
		'h2',
		'.h2',
	];

	/**
	 * H3 selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_H3 = [
		'h3',
		'.h3',
	];

	/**
	 * H4 selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_H4 = [
		'h4',
		'.h4',
	];

	/**
	 * H5 selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_H5 = [
		'h5',
		'.h5',
	];

	/**
	 * H6 selectors.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_H6 = [
		'h6',
		'.h6',
	];

	/**
	 * Paragraphs.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PARAGRAPHS = [
		'p',
	];

	/**
	 * Blockquote.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOCKQUOTE = [
		'blockquote',
	];

	/**
	 * Form inputs.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_FORM_INPUTS = [
		'input',
		'select',
	];

	/**
	 * Header: Menu.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_STANDARD = [
		'.site-header .header-block',
	];

	/**
	 * Header: Sub menus.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_STANDARD_SUB = [
		'.site-header .header-block .standard-menu .sub-menu',
	];

	/**
	 * Header: Logo.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_HEADER_LOGO = [
		'.site-header .header-logo',
	];

	/**
	 * Header: Top Bar.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_HEADER_TOP_BAR = [
		'.site-header .top-header-bar',
	];

	/**
	 * Header: Mini Cart.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_HEADER_MINI_CART = [
		'.site-header .mini-cart-popup',
	];


	/**
	 * Header: Fullscreen menu.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_FULLSCREEN = [
		'.fullscreen-menu .fullscreen-menu-navigation',
	];

	/**
	 * Header: Fullscreen sub menus.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_FULLSCREEN_SUB = [
		'.fullscreen-menu .fullscreen-menu-navigation .sub-menu li',
	];

	/**
	 * Header: Fullscreen footer.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_FULLSCREEN_FOOTER = [
		'.fullscreen-menu .fullscreen-menu-footer',
	];

	/**
	 * Header: Off-Canvas Top menu.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_TOP = [
		'.top-menu-container .top-menu',
	];

	/**
	 * Header: Off-Canvas Top sub menus.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_TOP_SUB = [
		'.top-menu-container .top-menu .menu li ul',
	];

	/**
	 * Header: Off-Canvas Top widgets title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_TOP_WIDGETS_TITLE = [
		'.top-menu-container .widget-area .widget :is(.wp-block-group>:first-child.wp-block-heading,.wp-block-heading:first-of-type,.widget-title)',
		'body.wp-block-widget-area__inner-blocks[data-widget-area-id="top_menu_sidebar"] .wp-block-group > .wp-block-heading:first-child',
	];

	/**
	 * Header: Off-Canvas Top widgets content.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_TOP_WIDGETS_CONTENT = [
		'.top-menu-container .widget',
	];

	/**
	 * Header: Off-Canvas Side menu.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_SIDEBAR = [
		'.sidebar-menu-wrapper .sidebar-main-menu',
	];

	/**
	 * Header: Off-Canvas Side sub menus.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_SIDEBAR_SUB = [
		'.sidebar-menu-wrapper .sidebar-main-menu .menu li ul',
	];

	/**
	 * Header: Off-Canvas Side widgets title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_SIDEBAR_WIDGETS_TITLE = [
		'.sidebar-menu-wrapper .sidebar-menu-container .widget :is(.wp-block-group>:first-child.wp-block-heading,.wp-block-heading:first-of-type,.widget-title)',
		'body.wp-block-widget-area__inner-blocks[data-widget-area-id="sidebar_menu_sidebar"] .wp-block-group > .wp-block-heading:first-child',
	];

	/**
	 * Header: Off-Canvas Side widgets content.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_SIDEBAR_WIDGETS_CONTENT = [
		'.sidebar-menu-wrapper .widget',
	];

	/**
	 * Mobile menu.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_MENU_MOBILE = [
		'.mobile-menu',
	];

	/**
	 * Page title: Title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PAGE_TITLE_TITLE = [
		'.section-title :is(h1, h2, h3, h4, h5, h6), .search-results-info :is(h1, h2, h3, h4, h5, h6), .shop-heading .page-title:is(h1, h2, h3, h4, h5, h6)',
	];

	/**
	 * Page title: Description.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PAGE_TITLE_DESCRIPTION = [
		'.section-title :is(.page-heading__description, .term-description, p), .search-results-info p, .shop-heading .woocommerce-result-count',
	];

	/**
	 * Page title: Breadcrumbs.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PAGE_TITLE_BREADCRUMBS = [
		'.woocommerce-breadcrumb, .breadcrumb__container',
	];


	/**
	 * Portfolio: Card title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_ITEM_TITLE = [
		'.portfolio-item .portfolio-item__title',
	];

	/**
	 * Portfolio: Card subtitle.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_ITEM_SUBTITLE_CATEGORY = [
		'.portfolio-item .portfolio-item__subtitle',
	];

	/**
	 * Portfolio: Category Filter.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_CATEGORY_FILTER = [
		'.portfolio-filters .portfolio-filters__terms',
	];

	/**
	 * Project: Title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_ITEM_TITLE_SINGLE = [
		'.single-portfolio__title :is(h1)',
	];

	/**
	 * Project: Subtitle.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_ITEM_SUB_TITLES = [
		'.single-portfolio__title__subtitle',
	];

	/**
	 * Project: Description.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_ITEM_CONTENT = [
		'.single-portfolio__entry-content',
	];

	/**
	 * Project: Checklist title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_ITEM_CHECKLIST_TITLES = [
		'.single-portfolio__checklist :is(h3)',
	];

	/**
	 * Project: Navigation.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_PORTFOLIO_ITEM_NAVIGATION = [
		'.single-portfolio .adjacent-post-link__text-primary',
	];

	/**
	 * Shop: Card title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_CARD_TITLE = [
		'.lb-element-woocommerce-product-title',
	];

	/**
	 * Shop: Card price.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_CARD_PRICE = [
		'.lb-element-woocommerce-product-price',
	];

	/**
	 * Shop: Card description.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_CARD_DESCRIPTION = [
		'.lb-element-woocommerce-product-description',
	];


	/**
	 * Shop: Category title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_CATEGORY_TITLE = [
		'.category-box__title h2',
	];

	/**
	 * Product: Title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_PRODUCT_PRODUCT_TITLE = [
		'.single-product .summary .product_title',
	];

	/**
	 * Product: Price.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_PRODUCT_PRODUCT_PRICE = [
		'.single-product .summary .price',
	];

	/**
	 * Product: Related Title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_PRODUCT_PRODUCT_RELATED_TITLE = [
		'.single-product :is(.related, .upsells) > h2:first-of-type',
	];

	/**
	 * Product: Tabs Titles.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_PRODUCT_PRODUCT_TABS_TITLE = [
		'.single-product :is(.tabs .tabs__panel, .panels-stack .panels-stack__panel, .accordion .accordion__item-content) > h2:first-of-type',
		'.single-product :is(.woocommerce-Reviews-title, #review_form #reply-title)',
	];

	/**
	 * Product: Tabs.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SHOP_PRODUCT_PRODUCT_TABS = [
		'.single-product :is(.tabs .tabs__list a, .accordion__item-toggle__title)',
	];

	/**
	 * Blog post title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_TITLE = [
		'.blog-posts .post-item .post-details .post-title',
		'.wpb_wrapper .lab-blog-posts .blog-post-entry .blog-post-content-container .blog-post-title',
	];

	/**
	 * Blog post post excerpt.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_EXCERPT = [
		'.blog-posts .post-item .post-details .post-excerpt',
	];

	/**
	 * Blog post meta.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_META = [
		'.blog-posts .post-item .post-details .post-meta',
	];

	/**
	 * Blog post title (single page).
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_TITLE_SINGLE = [
		'.single-post .entry-header .post-title',
	];

	/**
	 * Blog post meta single.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_TITLE_META_SINGLE = [
		'.single-post .entry-header .entry-meta',
	];

	/**
	 * Blog post author box title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_AUTHOR_BOX_TITLE = [
		'.single-post .entry-author__details .entry-author__details-name .author-name',
	];

	/**
	 * Blog post author box description.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_AUTHOR_BOX_DESCRIPTION = [
		'.single-post .entry-author__details',
	];

	/**
	 * Blog post navigation.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_NAVIGATION = [
		'.single-post .adjacent-post-link__text-primary',
	];

	/**
	 * Blog post related title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_RELATED_TITLE = [
		'.single-post .related-posts__title',
	];

	/**
	 * Blog post comments title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_COMMENTS_TITLE = [
		'.single-post .post-comments .post-comments__section-title h2',
	];

	/**
	 * Blog post commenter name.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BLOG_POST_COMMENTER_NAME = [
		'.comments-list .comment-details .name',
	];

	/**
	 * Search results title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SEARCH_RESULTS_TITLE = [
		'.search-results .search-results__entry-content .entry-title',
	];

	/**
	 * Search results title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SEARCH_RESULTS_DESCRIPTION = [
		'.search-results .search-results__entry-content',
	];

	/**
	 * Footer widgets title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_FOOTER_WIDGETS_TITLE = [
		'.site-footer .widget :is(.wp-block-group>:first-child.wp-block-heading,.wp-block-heading:first-of-type,.widget-title)',
		'body.wp-block-widget-area__inner-blocks[data-widget-area-id^="footer_sidebar"] .wp-block-group > .wp-block-heading:first-child',
	];

	/**
	 * Footer widgets content.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_FOOTER_WIDGETS_CONTENT = [
		'.site-footer .widget',
	];

	/**
	 * Sidebar widget title.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SIDEBAR_WIDGETS_TITLE = [
		':is(.sidebar, .site-footer, .sidebar-menu-wrapper, .top-menu-container) .widget :is(.wp-block-group > .wp-block-heading:first-child, .wp-block-heading:first-of-type, .widget-title)',
		'body.wp-block-widget-area__inner-blocks .wp-block-group > .wp-block-heading:first-child',
	];

	/**
	 * Sidebar widget content.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_SIDEBAR_WIDGETS_CONTENT = [
		':is(.sidebar,.site-footer,.sidebar-menu-wrapper,.top-menu-container) .widget',
	];

	/**
	 * Button.
	 *
	 * @var string[]
	 */
	public static $SELECTORS_BUTTON = [
		':is(.button, [type=button], [type=submit], .elementor-button)',
	];

	public static $SELECTORS_BUTTON_XS = [
		'.button-size-xsmall',
	];

	public static $SELECTORS_BUTTON_S = [
		'.button-size-small',
	];

	public static $SELECTORS_BUTTON_L = [
		'.button-size-large',
	];

	public static $SELECTORS_BUTTON_XL = [
		'.button-size-xlarge',
	];
	/**
	 * Group two or more selectors.
	 *
	 * @param $args,...
	 *
	 * @return array
	 */
	public static function group( $args ) {
		$group = [];

		foreach ( func_get_args() as $arg ) {
			if ( is_array( $arg ) ) {
				$group = array_merge( $group, $arg );
			} elseif ( is_string( $arg ) ) {
				$group = array_merge( $group, [ $arg ] );
			}
		}

		return $group;
	}
}
