<?php
/**
 * TypoLab - ultimate font management library.
 *
 * Font appearance settings.
 *
 * @author Laborator
 * @link   https://laborator.co
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TypoLab_Font_Appearance_Settings {

	/**
	 * Get raw font appearance settings (directly from database, not processed).
	 *
	 * @return array
	 */
	public static function get_settings_raw() {
		return TypoLab_Legacy_Migration::legacy_font_sizes( TypoLab::get_option( 'font_appearance', [] ) );
	}

	/**
	 * Get settings as objects.
	 *
	 * @param bool $to_array
	 *
	 * @return TypoLab_Font_Appearance_Element[]|array
	 */
	public static function get_settings( $to_array = false ) {

		// Return as array
		if ( $to_array ) {
			return array_map(
				function ( $element ) {
					return $element->to_array();
				},
				self::get_settings()
			);
		}

		// Return array of objects
		$settings = [];

		foreach ( self::get_settings_raw() as $group_id => $elements ) {
			foreach ( $elements as $element_id => $element ) {
				$settings[] = new TypoLab_Font_Appearance_Element(
					array_merge(
						$element,
						[
							'id'       => $element_id,
							'group_id' => $group_id,
						]
					)
				);
			}
		}

		return $settings;
	}

	/**
	 * Save font sizes.
	 *
	 * @param array $settings
	 */
	public static function set_settings( $settings ) {
		TypoLab::set_option( 'font_appearance', self::validate_settings( $settings ) );
	}

	/**
	 * Validate font appearance settings.
	 *
	 * @param array $settings
	 */
	public static function validate_settings( $settings ) {
		if ( is_array( $settings ) ) {
			$devices = [ 'general', 'tablet', 'mobile' ];

			return array_filter(
				array_map(
					// Selector groups
					function ( $selectors ) use ( $devices ) {
						if ( is_array( $selectors ) ) {
							$selectors = array_filter(
								array_map(
									// Selector
									function ( $selector ) use ( $devices ) {
										return array_filter(
											array_map(
												// Selector entry (font size, line height, letter spacing, text transform)
												function ( $entry ) {
													if ( is_array( $entry ) ) {
														return array_map(
															// Responsive value
															function ( $entry_value ) {
																if ( empty( $entry_value ) || 'px' === strtolower( $entry_value ) ) {
																	return null;
																}
																return $entry_value;
															},
															$entry
														);
													}
													return $entry;
												},
												$selector
											),
											// Filter empty entries
											function ( $selector ) use ( $devices ) {
												foreach ( $devices as $device ) {
													if ( ! empty( $selector[ $device ] ) ) {
														return true;
													}
												}
												return false;
											}
										);
									},
									$selectors
								),
								// Filter empty
								function ( $selectors ) {
									return ! empty( $selectors );
								}
							);
						}
						return $selectors;
					},
					$settings
				),
				// Filter empty
				function ( $groups ) {
					return ! empty( $groups );
				}
			);
		}

		return $settings;
	}
}
