<?php
/**
 * Kalium WordPress Theme
 *
 * Blog Page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_post_types_blog_page',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Blog Page',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'archive' ),
	]
);

/**
 * Section: Blog page.
 */

// Section
kalium_customize_register_section(
	'archive',
	[
		'title' => 'Blog Page',
	]
);

// General tab
kalium_customize_general_tab();

// Blog Layout
kalium_customize_register_control(
	'blog_layout',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Layout',
		'choices'       => [
			'list' => [
				'label' => 'List',
				'image' => kalium()->assets_url( 'admin/images/theme-options/blog-layout-list.svg' ),
			],
			'grid' => [
				'label' => 'Grid',
				'image' => kalium()->assets_url( 'admin/images/theme-options/blog-layout-grid.svg' ),
			],
		],
		'aspect_ratio'  => '109:81',
	]
);

// Columns
kalium_customize_register_control(
	'blog_grid_columns',
	[
		'type'           => 'kalium-quantity',
		'heading_title'  => 'Grid Options',
		'label'          => 'Columns',
		'responsive'     => true,
		'reset'          => true,
		'separator'      => true,
		'separator_type' => 4,
		'default'        => [
			'desktop' => 3,
			'tablet'  => 2,
			'mobile'  => 1,
		],
		'input_style'    => 'width:120px',
		'min'            => 1,
		'max'            => 4,
		'dependency'     => [
			'blog_layout' => 'grid',
		],
	]
);

// Columns gap
kalium_customize_register_control(
	'blog_grid_columns_gap',
	[
		'type'             => 'kalium-range',
		'label'            => 'Gap',
		'responsive'       => true,
		'reset'            => true,
		'min'              => 0,
		'slider_max'       => 100,
		'suffix'           => 'PX',
		'initial_position' => 30,
		'placeholder'      => 30,
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Layout mode
kalium_customize_register_control(
	'blog_grid_masonry_mode',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Masonry Mode',
		'default'    => true,
		'dependency' => [
			'blog_layout' => 'grid',
		],
	]
);

// Featured Image
kalium_customize_register_control(
	'blog_thumbnails',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Card Options',
		'label'         => 'Featured Image',
		'separator'     => true,
		'default'       => true,
		'section_link'  => kalium()->customize->section_id( 'featured_image' ),
	]
);

// Title
kalium_customize_register_control(
	'blog_post_title',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Title',
		'default' => true,
	]
);

// Excerpt
kalium_customize_register_control(
	'blog_post_excerpt',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Excerpt',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'post_excerpt' ),
	]
);

// Post Meta
kalium_customize_register_control(
	'blog_post_meta',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Post Meta',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'post_meta' ),
	]
);

// Show Header Title
kalium_customize_register_control(
	'blog_show_header_title',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Page Elements',
		'label'         => 'Title & Description',
		'separator'     => true,
		'default'       => true,
		'section_link'  => kalium()->customize->section_id( 'page_heading' ),
	]
);

// Sidebar
kalium_customize_register_control(
	'blog_sidebar',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Sidebar',
		'help'         => 'Allow sidebar on your blog page. To populate blog sidebar, navigate to <a href="widgets.php" target="_blank" rel="noopener">Widgets > Blog Archive</a> area.',
		'section_link' => kalium()->customize->section_id( 'sidebar' ),
	]
);

// Pagination
kalium_customize_register_control(
	'blog_pagination',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Pagination',
		'section_link' => kalium()->customize->section_id( 'pagination' ),
	]
);

// End general tab
kalium_customize_end_tab();

/**
 * Style tab.
 */

// Style tab
kalium_customize_style_tab();

// Blog post style
kalium()->customize->register_style_settings(
	'blog_post_style',
	[
		'settings'              => [
			'bg',
			'headings',
			'text',
			'padding',
			'border',
			'border_radius',
			'box_shadow',
		],
		'css_selector'          => '.blog-posts',
		'css_var_prefix'        => 'post-item',
		'add_padding_class'     => true,
		'setting_bg'            => [
			'heading_title' => 'Card Style',
		],
		'setting_text'          => [
			'default' => kalium_color_reference( 'theme_colors_text.normal' ),
		],
		'setting_padding'       => [
			'default' => [
				'link' => true,
			],
		],
		'setting_border_radius' => [
			'default' => [
				'link' => true,
			],
		],
		'setting_headings'      => [
			'default' => kalium_color_reference( 'theme_colors_headings' ),
			'css_var' => 'post-item-title',
			'label'   => 'Title',
		],
	]
);

// End style tab
kalium_customize_end_tab();

/**
 * Subsection: Post Thumbnail.
 */

// Subsection: Featured Image
kalium_customize_register_section(
	'featured_image',
	[
		'title' => 'Featured Image',
	]
);

// General tab
kalium_customize_general_tab();

// Thumbnail Hover Effect
kalium_customize_register_control(
	'blog_thumbnail_hover_effect',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Hover Effect',
		'default' => true,
	]
);

// Image Placeholder
kalium_customize_register_control(
	'blog_thumbnails_placeholder',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Image Placeholder',
		'help'    => 'If no featured image is assigned, show default placeholder image',
		'default' => true,
	]
);

// Blog post image size
kalium()->customize->register_image_size_settings(
	'blog_thumbnail',
	[
		'default' => 'large',
	]
);

// Blog post image aspect ratio
kalium()->customize->register_aspect_ratio_settings( 'blog_thumbnail' );

// Post Format Content
kalium_customize_register_control(
	'blog_post_formats',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Post Formats',
		'label'         => 'Post Format Content',
		'separator'     => true,
		'default'       => true,
	]
);

// Post Format icon
kalium_customize_register_control(
	'blog_post_type_icon',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Post Format Icon',
		'default' => true,
	]
);

// End general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Featured Image width
kalium_customize_register_control(
	'blog_thumbnail_width',
	[
		'type'             => 'kalium-range',
		'label'            => 'Width',
		'reset'            => true,
		'responsive'       => true,
		'units'            => kalium_get_default_units( [ '%', 'px' ] ),
		'initial_position' => 35,
		'min'              => [
			'%'  => 10,
			'px' => 100,
		],
		'slider_max'       => [
			'%'  => 100,
			'px' => 500,
		],
		'default'          => [
			'desktop' => '35%',
			'mobile'  => '100%',
		],
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'blog_layout' => 'list',
		],
	]
);

// Featured Image spacing
kalium_customize_register_control(
	'blog_thumbnail_spacing',
	[
		'type'             => 'kalium-range',
		'label'            => 'Gap',
		'reset'            => true,
		'responsive'       => true,
		'units'            => kalium_get_default_units( [ 'px', '%' ] ),
		'placeholder'      => 30,
		'initial_position' => 30,
		'min'              => [
			'px' => 0,
			'%'  => 0,
		],
		'slider_max'       => [
			'px' => 100,
			'%'  => 50,
		],
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Post featured image border radius
kalium_customize_register_control(
	'blog_thumbnail_border_radius',
	[
		'type'       => 'kalium-multi-numeric',
		'reset'      => true,
		'responsive' => true,
		'label'      => 'Border Radius',
		'units'      => kalium_get_default_units(),
		'default'    => [
			'link' => true,
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Boundless post featured image
kalium_customize_register_control(
	'blog_thumbnail_boundless',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Boundless Image',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Center vertically featured image
kalium_customize_register_control(
	'blog_thumbnail_content_valign',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Vertical Alignment',
		'reset'      => true,
		'choices'    => [
			'top'    => [
				'icon' => 'verticalAlignTop',
			],
			'center' => [
				'icon' => 'verticalAlignCenter',
			],
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'blog_layout' => 'list',
		],
	]
);

// Hover Background Color
kalium_customize_register_control(
	'blog_thumbnail_hover_bg',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Hover Layer',
		'label'         => 'Background',
		'reset'         => true,
		'separator'     => true,
		'default'       => kalium_color_reference( 'theme_colors.color-1', 0.9 ),
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'blog_thumbnail_hover_effect' => true,
		],
	]
);

// Hover layer padding
kalium_customize_register_control(
	'blog_thumbnail_hover_padding',
	[
		'type'       => 'kalium-range',
		'label'      => 'Offset',
		'min'        => 0,
		'max'        => 50,
		'default'    => 0,
		'reset'      => true,
		'responsive' => true,
		'suffix'     => 'PX',
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'blog_thumbnail_hover_effect' => true,
		],
	]
);

// Thumbnail Hover Icon
kalium_customize_register_control(
	'blog_thumbnail_hover_icon',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Icon',
		'inline_label' => false,
		'choices'      => [
			'none'   => 'None',
			'eye'    => 'Eye Icon',
			'custom' => 'Custom Icon',
		],
		'dependency'   => [
			'blog_thumbnail_hover_effect' => true,
		],
	]
);

// Thumbnail Hover Icon Eye
kalium_customize_register_control(
	'blog_thumbnail_hover_icon_eye',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Eye Icon',
		'choices'    => [
			'static'   => 'Static',
			'animated' => 'Animated',
		],
		'dependency' => [
			'blog_thumbnail_hover_effect' => true,
			'blog_thumbnail_hover_icon'   => 'eye',
		],
	]
);

// Custom Hover icon
kalium_customize_register_control(
	'blog_thumbnail_hover_icon_custom',
	[
		'type'           => 'kalium-media',
		'label'          => 'Custom Icon',
		'inline_label'   => true,
		'height'         => 65,
		'library_params' => [
			'type' => 'image',
		],
		'dependency'     => [
			'blog_thumbnail_hover_effect' => true,
			'blog_thumbnail_hover_icon'   => 'custom',
		],
	]
);

// Custom Hover icon width
kalium_customize_register_control(
	'blog_thumbnail_hover_icon_custom_width',
	[
		'type'       => 'kalium-range',
		'label'      => 'Icon Width',
		'min'        => 0,
		'max'        => 100,
		'default'    => 40,
		'reset'      => true,
		'suffix'     => 'PX',
		'dependency' => [
			'blog_thumbnail_hover_effect' => true,
			'blog_thumbnail_hover_icon'   => 'custom',
		],
	]
);

// Placeholder image bg color
kalium_customize_register_control(
	'blog_thumbnail_placeholder_bg',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Image Placeholder',
		'label'         => 'Color',
		'reset'         => true,
		'separator'     => true,
		'default'       => kalium_color_reference( 'theme_colors_border' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'blog_thumbnails_placeholder' => true,
		],
	]
);

// Background image
kalium_customize_register_control(
	'blog_thumbnail_placeholder_image',
	[
		'type'           => 'kalium-media',
		'label'          => 'Image',
		'reset'          => true,
		'inline_label'   => true,
		'height'         => 60,
		'library_params' => [
			'type' => 'image',
		],
		'dependency'     => [
			'blog_thumbnails_placeholder' => true,
		],
	]
);

// Post Format icon
kalium_customize_register_control(
	'blog_post_type_icon_position',
	[
		'type'          => 'kalium-align-matrix',
		'heading_title' => 'Post Format Icon',
		'label'         => 'Position',
		'separator'     => true,
		'width'         => 40,
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'blog_post_type_icon' => true,
		],
	]
);

// Post Format Icon offset
kalium_customize_register_control(
	'blog_post_type_icon_offset',
	[
		'type'             => 'kalium-range',
		'label'            => 'Offset',
		'reset'            => true,
		'responsive'       => true,
		'units'            => kalium_get_default_units( 'length' ),
		'initial_position' => 15,
		'slider_min'       => 0,
		'slider_max'       => 50,
		'placeholder'      => 15,
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'blog_post_type_icon'          => true,
			'blog_post_type_icon_position' => [
				'value'   => 'center center',
				'compare' => '!=',
			],
		],
	]
);

// End style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Post excerpt.
 */

// Subsection: Post Excerpt
kalium_customize_register_section(
	'post_excerpt',
	[
		'title' => 'Post Excerpt',
	]
);

// Excerpt Length
kalium_customize_register_control(
	'blog_post_excerpt_length',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Max Words',
		'input_style' => 'width:120px',
		'reset'       => true,
		'min'         => 5,
		'max'         => 300,
		'default'     => 25,
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Post meta.
 */

// Subsection: Post Meta
kalium_customize_register_section(
	'post_meta',
	[
		'title' => 'Post Meta',
	]
);

// Date
kalium_customize_register_control(
	'blog_post_date',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Date',
		'default' => true,
	]
);

// Category
kalium_customize_register_control(
	'blog_category',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Category',
		'default' => true,
	]
);

// Icon
kalium_customize_register_control(
	'blog_post_meta_icon',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Display Icon',
		'separator'      => true,
		'separator_type' => 3,
		'default'        => true,
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Title and Description.
 */

// Subsection: Title and Description
kalium_customize_register_section(
	'page_heading',
	[
		'title' => 'Title & Description',
	]
);

// Blog Title
kalium_customize_register_control(
	'blog_title',
	[
		'type'         => 'kalium-text',
		'label'        => 'Blog Title',
		'inline_label' => false,
		'default'      => 'Blog',
	]
);

// Blog Description
kalium_customize_register_control(
	'blog_description',
	[
		'type'    => 'kalium-textarea',
		'label'   => 'Blog Description',
		'rows'    => 7,
		'default' => 'Blog description area. To edit, navigate to Customizer > Blog > Blog Page > Title & Description.',
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Sidebar.
 */

// Subsection: Sidebar
kalium_customize_register_section(
	'sidebar',
	[
		'title' => 'Sidebar',
	]
);

// Sidebar Alignment
kalium_customize_register_control(
	'blog_sidebar_align',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Sidebar Align',
		'choices' => [
			'left'  => [
				'label' => 'Show on Left',
				'icon'  => 'justifyLeft',
				'size'  => 16,
			],
			'right' => [
				'label' => 'Show on Right',
				'icon'  => 'justifyRight',
				'size'  => 16,
			],
		],
		'default' => 'right',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Sidebar Widgets
kalium_customize_register_control(
	'_kalium_blog_sidebar_widgets',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Sidebar Widgets',
		'section_link' => kalium()->customize->section_id( 'widgets', false ),
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Pagination.
 */

// Subsection: Pagination
kalium_customize_register_section(
	'pagination',
	[
		'title' => 'Pagination',
	]
);

// Pagination settings
kalium()->customize->register_pagination_settings( 'blog_pagination' );

// End of current section
kalium_customize_end_section();

// End of parent section (kalium_post_types_blog_page)
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Sidebar align
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'blog_sidebar_align',
		],
		'content' => 'data.api.toggleClass( ".blog .content-wrapper", "sidebar-" + data.blog_sidebar_align, [ "sidebar-left", "sidebar-right" ] );',
	]
);

// Style
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'blog_grid_columns_gap',
			'blog_thumbnail_aspect_ratio',
			'blog_thumbnail_aspect_ratio_custom',
			'blog_thumbnail_width',
			'blog_thumbnail_spacing',
			'blog_thumbnail_border_radius',
			'blog_thumbnail_boundless',
			'blog_thumbnail_content_valign',
			'blog_thumbnail_hover_bg',
			'blog_thumbnail_hover_padding',
			'blog_thumbnail_placeholder_bg',
			'blog_post_type_icon_position',
			'blog_post_type_icon_offset',
		],
		'content' => <<<EOD
			<#
				data.api.toggleClass( '.blog-posts', 'blog-posts--boundless-image', data.blog_thumbnail_boundless );
				data.api.toggleClass( '.blog-posts', 'blog-posts--valign-center', 'list' === data.api.getSetting( 'blog_layout' ) && 'center' === data.blog_thumbnail_content_valign );
		
				var postFormatPosition = data.blog_post_type_icon_position.split( ' ' );
				
				data.api.getElements( '.blog-posts .post-format-icon' ).forEach( function( element ) {
					element.setAttribute( 'data-valign', postFormatPosition[0] );
					element.setAttribute( 'data-halign', postFormatPosition[1] );
				} );
				
				// Relayout Isotope items
				if ( data.api.getSetting( 'blog_grid_masonry_mode' ) ) {
					data.api.relayoutIsotope( '.blog-posts' );
				}
			#>
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'grid-gap',
				value: data.blog_grid_columns_gap,
				addUnit: 'px',
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'custom-aspect-ratio',
				value: data.blog_thumbnail_aspect_ratio,
				parser: function( value ) {
					if ( 'custom' === value ) {
						return data.api.currentResponsiveValue( data.blog_thumbnail_aspect_ratio_custom );
					}
					
					return 'auto' === value ? null : value;
				},
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'post-item-image-width',
				value: data.blog_thumbnail_width,
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'post-item-image-spacing',
				value: data.blog_thumbnail_spacing,
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'post-item-image-border-radius',
				value: data.blog_thumbnail_border_radius,
				parser: data.api.toLength,
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'post-item-hover-layer-bg',
				value: data.blog_thumbnail_hover_bg,
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'post-item-hover-layer-offset',
				value: data.blog_thumbnail_hover_padding,
				addUnit: 'px',
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'post-item-image-placeholder-bg',
				value: data.blog_thumbnail_placeholder_bg,
			} ) }}}
			{{{ data.api.printInlineStyle( {
				selector: '.blog-posts',
				varName: 'post-item-icon-offset',
				value: data.blog_post_type_icon_offset,
			} ) }}}
EOD,
	]
);
