<?php
/**
 * Kalium WordPress Theme
 *
 * Custom Post Type archive options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 *
 * @var array $section
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Vars
$section_id         = $section['id'];
$post_type          = $section['post_type'];
$post_type_obj      = get_post_type_object( $post_type );
$archive_section_id = $section_id . '_archive';

// Section link control
kalium_customize_register_control(
	$archive_section_id,
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Archive',
		'priority'     => kalium()->customize->get_next_priority(),
		'section'      => $section_id,
		'section_link' => $archive_section_id,
	]
);

// Section
kalium_customize_register_section(
	$archive_section_id,
	[
		'title' => "{$post_type_obj->label} - Archive",
	]
);
