<?php
/**
 * Kalium WordPress Theme
 *
 * Custom Post Type singular options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 *
 * @var array $section
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Vars
$section_id          = $section['id'];
$post_type           = $section['post_type'];
$post_type_obj       = get_post_type_object( $post_type );
$singular_section_id = $section_id . '_singular';

// Section link control
kalium_customize_register_control(
	$singular_section_id,
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Single',
		'priority'     => kalium()->customize->get_next_priority(),
		'section'      => $section_id,
		'section_link' => $singular_section_id,
	]
);


// Section
kalium_customize_register_section(
	$singular_section_id,
	[
		'title' => "{$post_type_obj->label} - Single",
	]
);
