<?php
/**
 * Kalium WordPress Theme
 *
 * Breadcrumb.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Breadcrumbs
$is_breadcrumb_navxt_active = kalium()->is->breadcrumb_navxt_active();

kalium_customize_register_control(
	'breadcrumbs',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Breadcrumb',
		'priority'     => kalium()->customize->get_next_priority(),
		'disabled'     => ! $is_breadcrumb_navxt_active,
		'help'         => $is_breadcrumb_navxt_active ? 'Display breadcrumb navigation to your website.' : 'To enable this option you must install and activate the "Breadcrumb NavXT" plugin.',
		'section_link' => kalium()->customize->section_id( 'breadcrumb' ),
	]
);

/**
 * Section: Breadcrumb.
 */

// Section
kalium_customize_register_section(
	'breadcrumb',
	[
		'title' => 'Breadcrumb',
	]
);

// General tab
kalium_customize_general_tab();

// Type
kalium_customize_register_control(
	'breadcrumb_border_type',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Type',
		'choices'       => [
			'no-border'         => [
				'label' => 'Type 1',
				'image' => kalium()->assets_url( 'admin/images/theme-options/breadcrumbs-no-border.svg' ),
			],
			'border-horizontal' => [
				'label' => 'Type 2',
				'image' => kalium()->assets_url( 'admin/images/theme-options/breadcrumbs-horizontal-border.svg' ),
			],
			'border'            => [
				'label' => 'Type 3',
				'image' => kalium()->assets_url( 'admin/images/theme-options/breadcrumbs-full-border.svg' ),
			],
		],
		'aspect_ratio'  => '67:49',
		'columns'       => 3,
	]
);

// Text Alignment
kalium_customize_register_control(
	'breadcrumb_alignment',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Text Alignment',
		'choices' => [
			'left'   => [
				'label' => 'Left',
				'icon'  => 'alignLeft',
				'size'  => 16,
			],
			'center' => [
				'label' => 'Center',
				'icon'  => 'alignCenter',
				'size'  => 16,
			],
			'right'  => [
				'label' => 'Right',
				'icon'  => 'alignRight',
				'size'  => 16,
			],
		],
	]
);

// Display / Homepage
kalium_customize_register_control(
	'breadcrumb_visibility_homepage',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Display',
		'label'         => 'Homepage',
		'separator'     => true,
	]
);

// Blog Page
kalium_customize_register_control(
	'breadcrumb_visibility_blog',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Blog Page',
		'default' => true,
	]
);

// Portfolio Page
kalium_customize_register_control(
	'breadcrumb_visibility_portfolio',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Portfolio Page',
		'default' => true,
	]
);

// Search Page
kalium_customize_register_control(
	'breadcrumb_visibility_search',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Search Page',
	]
);

// 404 Page
kalium_customize_register_control(
	'breadcrumb_visibility_404',
	[
		'type'  => 'kalium-toggle',
		'label' => '404 Page',
	]
);

// Responsive Settings / Desktop
kalium_customize_register_control(
	'breadcrumb_responsive',
	[
		'type'          => 'kalium-checkbox-button',
		'heading_title' => 'Responsive',
		'label'         => 'Visibility',
		'separator'     => true,
		'choices'       => [
			'desktop' => [
				'label' => 'Desktop',
				'icon'  => 'desktop',
			],
			'tablet'  => [
				'label' => 'Tablet',
				'icon'  => 'tablet',
			],
			'mobile'  => [
				'label' => 'Mobile',
				'icon'  => 'mobile',
			],
		],
		'allow_none'    => false,
		'default'       => [
			'desktop',
			'tablet',
			'mobile',
		],
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Background
kalium_customize_register_control(
	'breadcrumb_background_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Background',
		'reset'        => true,
		'enable_clear' => true,
	]
);

// Text
kalium_customize_register_control(
	'breadcrumb_text_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Separator',
		'reset'        => true,
		'enable_clear' => true,
	]
);

// Border
kalium_customize_register_control(
	'breadcrumb_border_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Border',
		'reset'        => true,
		'enable_clear' => true,
		'dependency'   => [
			'breadcrumb_border_type' => [
				'border',
				'border-horizontal',
			],
		],
	]
);

// Border Radius
kalium_customize_register_control(
	'breadcrumb_border_radius',
	[
		'type'    => 'kalium-multi-numeric',
		'label'   => 'Border Radius',
		'units'   => kalium_get_default_units( 'box-size' ),
		'default' => [
			'link' => true,
		],
	]
);

// Margin
kalium_customize_register_control(
	'breadcrumb_margin',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Margin',
		'value_props' => [
			'top'    => 'Top',
			'bottom' => 'Bottom',
		],
		'units'       => kalium_get_default_units( 'box-size' ),
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();
