<?php
/**
 * Kalium WordPress Theme
 *
 * Image Loading Placeholder.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 *
 * @var WP_Customize_Manager $wp_customize
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $wp_customize;

// Enqueue CSS loaders library
if ( kalium_is_customizer_preview_admin() ) {
	kalium_enqueue( 'css-loaders' );
}

// Section link control
kalium_customize_register_control(
	'kalium_general_image_placeholder',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Image Placeholder',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'image_placeholder' ),
	]
);

/**
 * Section: Image Placeholder.
 */

// Section
kalium_customize_register_section(
	'image_placeholder',
	[
		'title' => 'Image Placeholder',
	]
);

// General tab
kalium_customize_general_tab();

// Placeholder Type
kalium_customize_register_control(
	'image_loading_placeholder_type',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Type',
		'choices'       => [
			'plain'             => [
				'label' => 'Plain Color',
				'image' => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-color.svg' ),
			],
			'loading-animation' => [
				'label' => 'Loading Animation',
				'image' => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-animation.svg' ),
			],
			'custom-icon'       => [
				'label' => 'Custom Icon',
				'image' => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-custom.svg' ),
			],
		],
		'columns'       => 3,
		'aspect_ratio'  => '67:49',
		'show_labels'   => true,
		'tooltips'      => false,
		'default'       => 'plain',
	]
);

// Loading Animation
kalium_customize_register_control(
	'image_loading_placeholder_loading_animation',
	[
		'type'         => 'kalium-custom-select',
		'label'        => 'Loading Animation',
		'inline_label' => false,
		'choices'      => static function () {
			$loading_animations = [];

			foreach ( kalium_get_css_loading_animations() as $animation_name => $animation ) {
				$loading_animations[] = [
					'value' => $animation_name,
					'label' => $animation['title'],
					'hint'  => $animation['content'],
				];
			}

			return $loading_animations;
		},
		'dependency'   => [
			'image_loading_placeholder_type' => 'loading-animation',
		],
	]
);

// Custom Loading Icon
kalium_customize_register_control(
	'image_loading_placeholder_custom_icon',
	[
		'type'           => 'kalium-media',
		'label'          => 'Custom Image/Icon',
		'library_params' => [
			'type' => 'image',
		],
		'dependency'     => [
			'image_loading_placeholder_type' => 'custom-icon',
		],
	]
);

// Alignment
kalium_customize_register_control(
	'image_loading_placeholder_align',
	[
		'type'       => 'kalium-align-matrix',
		'label'      => 'Alignment',
		'width'      => 40,
		'default'    => 'center center',
		'dependency' => [
			'image_loading_placeholder_type' => [ 'loading-animation', 'custom-icon' ],
		],
	]
);

// Spacing (Padding)
kalium_customize_register_control(
	'image_loading_placeholder_spacing',
	[
		'type'             => 'kalium-range',
		'label'            => 'Padding',
		'min'              => 0,
		'max'              => 100,
		'initial_position' => 20,
		'suffix'           => 'PX',
		'dependency'       => [
			'image_loading_placeholder_type'  => [ 'loading-animation', 'custom-icon' ],
			'image_loading_placeholder_align' => [
				'value'   => 'center center',
				'compare' => '!=',
			],
		],
	]
);

// Size
kalium_customize_register_control(
	'image_loading_placeholder_size',
	[
		'type'       => 'kalium-range',
		'label'      => 'Animation Icon Size',
		'reset'      => true,
		'min'        => 10,
		'max'        => 150,
		'default'    => 35,
		'suffix'     => 'PX',
		'dependency' => [
			'image_loading_placeholder_type' => [ 'loading-animation', 'custom-icon' ],
		],
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Color Type
kalium_customize_register_control(
	'image_loading_placeholder_bg_type',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Background',
		'inline_label' => false,
		'choices'      => [
			'color'          => 'Color',
			'gradient'       => 'Gradient',
			'dominant-color' => 'Dominant Color',
		],
	]
);

// Background Color
kalium_customize_register_control(
	'image_loading_placeholder_bg_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Color',
		'reset'      => true,
		'default'    => kalium_color_reference( 'theme_colors_border' ),
		'dependency' => [
			'image_loading_placeholder_bg_type' => 'color',
		],
	]
);

// Gradient Background
kalium_customize_register_control(
	'image_loading_placeholder_bg_gradient',
	[
		'type'       => 'kalium-gradient-picker',
		'label'      => 'Gradient',
		'reset'      => true,
		'default'    => 'linear-gradient(135deg, #cccccc 0%, #8d8d8d 100%)',
		'dependency' => [
			'image_loading_placeholder_bg_type' => 'gradient',
		],
	]
);

// Loader Color
kalium_customize_register_control(
	'image_loading_placeholder_loader_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Loader Color',
		'reset'      => true,
		'separator'  => true,
		'default'    => kalium_color_reference( 'theme_colors_text.normal' ),
		'dependency' => [
			'image_loading_placeholder_type' => 'loading-animation',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();
