<?php
/**
 * Kalium WordPress Theme
 *
 * Video and Audio.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_general_media',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Media',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'media' ),
	]
);

/**
 * Section: Media.
 */

// Section
kalium_customize_register_section(
	'media',
	[
		'title' => 'Media',
	]
);

// Media Library
kalium_customize_register_control(
	'media_player_library',
	[
		'type'        => 'kalium-select',
		'label'       => 'Media Player',
		'input_style' => 'width:120px',
		'choices'     => [
			'native'  => 'Browser Native',
			'videojs' => 'Video.js',
		],
		'default'     => 'videojs',
	]
);

// Media Player Skin
kalium_customize_register_control(
	'videojs_player_skin',
	[
		'type'        => 'kalium-select',
		'label'       => 'Player Skin',
		'input_style' => 'width:120px',
		'choices'     => [
			'standard' => 'Standard',
			'minimal'  => 'Minimal',
		],
		'default'     => 'minimal',
		'dependency'  => [
			'media_player_library' => 'videojs',
		],
	]
);

// Autoplay
kalium_customize_register_control(
	'media_autoplay',
	[
		'type'        => 'kalium-select',
		'label'       => 'Autoplay Videos',
		'input_style' => 'width:120px',
		'choices'     => [
			'no'          => 'Disable',
			'yes'         => 'Always',
			'on-viewport' => 'When Visible on Viewport',
		],
	]
);

// Loop
kalium_customize_register_control(
	'media_loop',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Auto Repeat',
		'help'  => 'Repeat the video or audio from the beginning when it finishes.',
	]
);

// Native YouTube Player
kalium_customize_register_control(
	'videojs_youtube_player',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Default YouTube Player',
		'help'       => 'Choose if you want to show the YouTube native player or the default theme player.',
		'dependency' => [
			'media_player_library' => 'videojs',
		],
	]
);

// End of current section
kalium_customize_end_section();
