<?php
/**
 * Kalium WordPress Theme
 *
 * Post Types / Search Results.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Thumbnails
kalium_customize_register_control(
	'search_thumbnails',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Featured Image',
		'help'         => 'Show featured images in search results.',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'featured_image' ),
	]
);

// Allowed post types
kalium_customize_register_control(
	'exclude_search_post_types',
	[
		'type'           => 'kalium-checkbox',
		'label'          => 'Exclude Post Types',
		'help'           => 'Check any of the post types you want to hide in search results.',
		'inline_label'   => false,
		'separator'      => true,
		'separator_type' => 3,
		'choices'        => static function () {

			// Exclude Post Types
			$post_types = array_merge(
				[
					'post',
					'page',
				],
				get_post_types(
					[
						'_builtin'           => false,
						'publicly_queryable' => true,
					]
				)
			);

			return array_combine(
				$post_types,
				array_map(
					function ( $post_type ) {
						$post_type_obj = get_post_type_object( $post_type );

						return $post_type_obj->label;
					},
					$post_types
				)
			);
		},
	]
);

/**
 * Subsection: Featured Image.
 */

kalium_customize_register_section(
	'featured_image',
	[
		'title' => 'Featured Image',
	]
);

// General tab
kalium_customize_general_tab();

// Blog post image size
kalium()->customize->register_image_size_settings(
	'search_thumbnail',
	[
		'default'       => 'thumbnail',
		'heading_title' => null,
		'separator'     => false,
	]
);

// Thumbnail aspect ratio
kalium()->customize->register_aspect_ratio_settings( 'search_thumbnail' );

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Thumbnail width
kalium_customize_register_control(
	'search_thumbnail_width',
	[
		'type'       => 'kalium-range',
		'label'      => 'Width',
		'reset'      => true,
		'responsive' => true,
		'default'    => '120px',
		'units'      => kalium_get_default_units( [ 'px', '%' ] ),
		'min'        => [
			'px' => 50,
			'%'  => 10,
		],
		'max'        => [
			'px' => 500,
			'%'  => 100,
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Border radius
kalium_customize_register_control(
	'search_thumbnail_border_radius',
	[
		'type'       => 'kalium-multi-numeric',
		'label'      => 'Border Radius',
		'responsive' => true,
		'reset'      => true,
		'units'      => kalium_get_default_units( 'box-size' ),
		'default'    => [
			'link' => true,
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of section
kalium_customize_end_section();

/**
 * Update preview.
 */

// Featured Image
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'search_thumbnail_aspect_ratio',
			'search_thumbnail_aspect_ratio_custom',
			'search_thumbnail_width',
			'search_thumbnail_border_radius',
		],
		'content' => <<<EOD
{{{ data.api.printInlineStyle( {
	selector: '.search-results',
	varName: 'custom-aspect-ratio',
	value: data.search_thumbnail_aspect_ratio,
	parser: function( value ) {
		if ( 'custom' === value ) {
			return data.api.currentResponsiveValue( data.search_thumbnail_aspect_ratio_custom );
		}
		
		return 'auto' === value ? null : value;
	},
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: '.search-results',
	varName: 'results-thumbnail-width',
	value: data.search_thumbnail_width,
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: '.search-results',
	varName: 'results-thumbnail-border-radius',
	value: data.search_thumbnail_border_radius,
	parser: 'length',
} ) }}}
EOD,
	]
);
