<?php
/**
 * Kalium WordPress Theme
 *
 * Sidebars options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Tab: General
kalium_customize_general_tab();

// Sidebar type
kalium_customize_register_control(
	'sidebar_type',
	[
		'type'         => 'kalium-radio-image',
		'label'        => 'Type',
		'choices'      => [
			'plain'  => [
				'label' => 'Type 1',
				'image' => kalium()->assets_url( 'admin/images/theme-options/sidebar-type-1.svg' ),
			],
			'styled' => [
				'label' => 'Type 2',
				'image' => kalium()->assets_url( 'admin/images/theme-options/sidebar-type-2.svg' ),
			],
		],
		'show_labels'  => false,
		'tooltips'     => true,
		'aspect_ratio' => '66:48',
		'default'      => 'plain',
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Sidebar Width
kalium_customize_register_control(
	'sidebar_width',
	[
		'type'             => 'kalium-range',
		'label'            => 'Sidebar Width',
		'reset'            => true,
		'min'              => 0,
		'max'              => 60,
		'suffix'           => '%',
		'placeholder'      => 25,
		'initial_position' => 25,
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Sidebar Gap
kalium_customize_register_control(
	'sidebar_gap',
	[
		'type'             => 'kalium-range',
		'label'            => 'Sidebar Gap',
		'reset'            => true,
		'min'              => 0,
		'max'              => 300,
		'suffix'           => 'PX',
		'placeholder'      => 30,
		'initial_position' => 30,
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Inner spacing
kalium_customize_register_control(
	'sidebar_padding',
	[
		'type'             => 'kalium-range',
		'label'            => 'Inner Spacing',
		'reset'            => true,
		'min'              => 5,
		'max'              => 100,
		'suffix'           => 'PX',
		'placeholder'      => 30,
		'initial_position' => 30,
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'sidebar_type' => 'styled',
		],
	]
);

// Vertical spacing
kalium_customize_register_control(
	'sidebar_widgets_spacing',
	[
		'type'             => 'kalium-range',
		'label'            => 'Widgets Vertical Spacing',
		'reset'            => true,
		'min'              => 0,
		'max'              => 100,
		'suffix'           => 'PX',
		'placeholder'      => 30,
		'initial_position' => 30,
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Separate widgets
kalium_customize_register_control(
	'sidebar_widgets_separate',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Separate Widgets',
		'reset'      => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'sidebar_type' => 'styled',
		],
	]
);

// Sidebar position in mobile
kalium_customize_register_control(
	'sidebar_mobile_position',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Mobile Position',
		'reset'   => true,
		'choices' => [
			'top'    => 'Top',
			'bottom' => 'Bottom',
		],
		'default' => 'bottom',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Sticky sidebar
kalium_customize_register_control(
	'sidebar_sticky',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Sticky Sidebar',
		'separator'      => true,
		'separator_type' => 3,
	]
);

// Sticky mode
kalium_customize_register_control(
	'sidebar_sticky_behavior',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Sticky Behavior',
		'reset'        => true,
		'inline_label' => false,
		'choices'      => [
			'sidebar' => 'Entire Sidebar',
			'widgets' => 'Widgets',
		],
		'dependency'   => [
			'sidebar_sticky' => true,
		],
	]
);

// Last widgets
kalium_customize_register_control(
	'sidebar_sticky_last_widgets',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Last Widgets',
		'reset'       => true,
		'input_style' => 'width:120px',
		'min'         => 1,
		'max'         => 10,
		'default'     => 1,
		'dependency'  => [
			'sidebar_sticky'          => true,
			'sidebar_sticky_behavior' => 'widgets',
		],
	]
);

// Sticky offset
kalium_customize_register_control(
	'sidebar_sticky_offset',
	[
		'type'             => 'kalium-range',
		'label'            => 'Offset From Top',
		'reset'            => true,
		'min'              => 0,
		'max'              => 300,
		'suffix'           => 'PX',
		'placeholder'      => 30,
		'initial_position' => 30,
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'sidebar_sticky' => true,
		],
	]
);

// Responsive
kalium_customize_register_control(
	'sidebar_visibility',
	[
		'type'          => 'kalium-checkbox-button',
		'heading_title' => 'Responsive',
		'label'         => 'Visible On',
		'separator'     => true,
		'reset'         => true,
		'inline_label'  => false,
		'choices'       => [
			'desktop' => [
				'label' => 'Desktop',
				'icon'  => 'desktop',
			],
			'tablet'  => [
				'label' => 'Tablet',
				'icon'  => 'tablet',
			],
			'mobile'  => [
				'label' => 'Mobile',
				'icon'  => 'mobile',
			],
		],
		'default'       => [
			'desktop',
			'tablet',
			'mobile',
		],
		'help'          => 'Select in which device types the sidebar will be visible.',
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// End of current tab
kalium_customize_end_tab();

// Tab: Style
kalium_customize_style_tab();

// Text and Title
kalium_customize_register_control(
	'sidebar_style_text',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Text',
		'label'         => 'Title & Text',
		'reset'         => true,
		'choices'       => [
			'title' => 'Title',
			'text'  => 'Text',
		],
		'tooltip'       => true,
		'default'       => [
			'title' => kalium_color_reference( 'theme_colors_headings' ),
			'text'  => kalium_color_reference( 'theme_colors_text.normal' ),
		],
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Links
kalium_customize_register_control(
	'sidebar_style_links',
	[
		'type'    => 'kalium-color',
		'label'   => 'Links',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
		],
		'tooltip' => true,
		'default' => [
			'normal' => kalium_color_reference( 'theme_colors_link.normal' ),
			'hover'  => kalium_color_reference( 'theme_colors_link.hover' ),
		],
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Sidebar background
kalium_customize_register_control(
	'sidebar_bg',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Container',
		'label'         => 'Background',
		'separator'     => true,
		'reset'         => true,
		'enable_clear'  => true,
		'default'       => kalium_color_reference( 'theme_colors_border' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'sidebar_type' => 'styled',
		],
	]
);

// Sidebar border
kalium_customize_register_control(
	'sidebar_border',
	[
		'type'         => 'kalium-border-box',
		'label'        => 'Border',
		'reset'        => true,
		'border_style' => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'sidebar_type' => 'styled',
		],
	]
);

// Sidebar shadow
kalium_customize_register_control(
	'sidebar_shadow',
	[
		'type'        => 'kalium-box-shadow',
		'label'       => 'Shadow',
		'reset'       => true,
		'units'       => kalium_get_default_units( 'box-size' ),
		'placeholder' => [
			'offset_x'      => 0,
			'offset_y'      => 0,
			'blur_radius'   => 5,
			'spread_radius' => 0,
		],
		'setting'     => [
			'transport' => 'postMessage',
		],
		'dependency'  => [
			'sidebar_type' => 'styled',
		],
	]
);

// Submenu Border Radius
kalium_customize_register_control(
	'sidebar_radius',
	[
		'type'       => 'kalium-multi-numeric',
		'label'      => 'Border Radius',
		'reset'      => true,
		'units'      => kalium_get_default_units( 'box-size' ),
		'min'        => 0,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'default'    => [
			'link' => true,
		],
		'dependency' => [
			'sidebar_type' => 'styled',
		],
	]
);

// End of current tab
kalium_customize_end_tab();

/**
 * Update options in preview.
 */

// Sidebar type and mobile position
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'sidebar_type',
			'sidebar_widgets_separate',
			'sidebar_mobile_position',
			'sidebar_visibility',
		],
		'content' => <<<EOD
	var sidebarWrapper = '.content-wrapper, .wpb_widgetised_column';

	// Sidebar style
	data.api.toggleClass( sidebarWrapper, 'sidebar-styled', 'styled' === data.sidebar_type );
	
	// Widgets separate
	data.api.toggleClass( sidebarWrapper, 'sidebar-widgets-separated', data.sidebar_widgets_separate );
	
	// Mobile position
	data.api.toggleClass( sidebarWrapper, 'sidebar-mobile-top', 'top' === data.sidebar_mobile_position );
	
	// Visibility
	[ 'desktop', 'tablet', 'mobile' ].forEach( function( deviceType ) {
		var className = 'sidebar-hide-' + deviceType;
		
		data.api.toggleClass( sidebarWrapper, className, ! _.contains( data.sidebar_visibility, deviceType ) );
	} );
EOD,
	]
);

// Sidebar mobile position
kalium_customize_register_preview_update(
	[
		'type'     => 'css',
		'selector' => '[data-inline-style="content-wrapper"]',
		'vars'     => [
			'sidebar_width',
			'sidebar_gap',
			'sidebar_padding',
			'sidebar_widgets_spacing',
			'sidebar_sticky_offset',
			'sidebar_style_text',
			'sidebar_style_links',
			'sidebar_bg',
			'sidebar_border',
			'sidebar_shadow',
			'sidebar_radius',
		],
		'content'  => '
		.content-wrapper {
			<# if ( data.api.isNumber( data.sidebar_width ) ) { #>
				{{ data.api.cssVarName( "sidebar-width" ) }}: {{ data.sidebar_width }}%;
			<# } #>
			<# if ( data.api.isNumber( data.sidebar_gap ) ) { #>
				{{ data.api.cssVarName( "sidebar-gap" ) }}: {{ data.sidebar_gap }}px;
			<# } #>
		}
		
		.has-sidebar .sidebar, .wpb_widgetised_column.sidebar {
		    <# if ( data.api.isNumber( data.sidebar_sticky_offset ) ) { #>
		        {{ data.api.cssVarName( "sticky-offset" ) }}: {{ data.sidebar_sticky_offset }}px;
		    <# } #>
			<# if ( data.sidebar_style_text.title ) { #>
				{{ data.api.cssVarName( "h2-color" ) }}: {{ data.api.parseColor( data.sidebar_style_text.title ) }};
			<# } #>
			<# if ( data.sidebar_style_text.text ) { #>
				{{ data.api.cssVarName( "body-color" ) }}: {{ data.api.parseColor( data.sidebar_style_text.text ) }};
			<# } #>
			<# if ( data.sidebar_style_links.normal ) { #>
				{{ data.api.cssVarName( "link-color" ) }}: {{ data.api.parseColor( data.sidebar_style_links.normal ) }};
			<# } #>
			<# if ( data.sidebar_style_links.hover ) { #>
				{{ data.api.cssVarName( "link-hover-color" ) }}: {{ data.api.parseColor( data.sidebar_style_links.hover ) }};
			<# } #>
			<# if ( data.api.isNumber( data.sidebar_padding ) ) { #>
				{{ data.api.cssVarName( "sidebar-padding" ) }}: {{ data.sidebar_padding }}px;
			<# } #>
			<# if ( data.api.isNumber( data.sidebar_widgets_spacing ) ) { #>
				{{ data.api.cssVarName( "sb-widgets-spacing" ) }}: {{ data.sidebar_widgets_spacing }}px;
			<# } #>
			{{ data.api.cssVarName( "sidebar-bg" ) }}: {{ data.api.parseColor( data.sidebar_bg ) || "transparent" }};
			<# if ( data.sidebar_border ) { #>
				<# var border = data.api.toBorderBox( data.sidebar_border ); #>
				{{ data.api.cssVarName( "sidebar-border-width" ) }}: {{ border.width }};
				{{ data.api.cssVarName( "sidebar-border-style" ) }}: {{ border.style }};
				{{ data.api.cssVarName( "sidebar-border-color" ) }}: {{ border.color }};
			<# } #>
			<# if ( data.api.hasBoxShadow( data.sidebar_shadow ) ) { #>
				{{ data.api.cssVarName( "sidebar-shadow" ) }}: {{ data.api.toBoxShadow( data.sidebar_shadow, "0 0 5px" ) }};
			<# } #>
			<# if ( data.api.hasMultiNumericValue( data.sidebar_radius ) ) { #>
				{{ data.api.cssVarName( "sidebar-radius" ) }}: {{ data.api.toLength( data.sidebar_radius ) }};
			<# } #>
		}',
	]
);
