<?php
/**
 * Kalium WordPress Theme
 *
 * Social Icons.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_general_social_icons',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Social Icons',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'social_icons' ),
	]
);

/**
 * Section: Social Icons.
 */

// Section
kalium_customize_register_section(
	'social_icons',
	[
		'title' => 'Social Icons',
	]
);

// Social Icons
kalium_customize_register_control(
	'social_icons',
	[
		'type'            => 'laborator-builder',
		'label'           => 'Social Icons',
		'help'            => 'Link your social accounts and display them throughout your website, with the various elements provided in the customizer.',
		'content_type_id' => 'social_icons',
		'default'         => static function () {
			return laborator_builder_get_content_type( 'social_icons' )->get_default_content();
		},
		'tags'            => 'social networks',
	]
);

// End of current section
kalium_customize_end_section();
