<?php
/**
 * Kalium WordPress Theme
 *
 * Header options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Vars
$is_woocommerce_active = kalium()->is->woocommerce_active();
$is_wpml_active        = kalium()->is->wpml_active();

// General tab
kalium_customize_general_tab();

// Layout
kalium_customize_register_control(
	'main_menu_type',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Layout',
		'choices'       => [
			'standard-menu' => [
				'label' => 'Standard',
				'image' => kalium()->assets_url( 'admin/images/theme-options/header-type-1.svg' ),
			],
			'full-bg-menu'  => [
				'label' => 'Fullscreen',
				'image' => kalium()->assets_url( 'admin/images/theme-options/header-type-3.svg' ),
			],
			'sidebar-menu'  => [
				'label' => 'Off-Canvas Side',
				'image' => kalium()->assets_url( 'admin/images/theme-options/header-type-4.svg' ),
			],
			'top-menu'      => [
				'label' => 'Off-Canvas Top',
				'image' => kalium()->assets_url( 'admin/images/theme-options/header-type-2.svg' ),
			],
			'custom-header' => [
				'label' => 'Custom',
				'image' => kalium()->assets_url( 'admin/images/theme-options/header-type-5.svg' ),
			],
		],
		'aspect_ratio'  => '117:49',
	]
);

// Standard / Hamburger menu
kalium_customize_register_control(
	'menu_standard_menu_bar_visible',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Standard Menu Options',
		'label'         => 'Hamburger Menu',
		'dependency'    => [
			'main_menu_type' => 'standard-menu',
		],
	]
);

// Animation
kalium_customize_register_control(
	'menu_standard_menu_bar_effect',
	[
		'type'       => 'kalium-select',
		'label'      => 'Animation',
		'choices'    => [
			'fade'         => 'Fade',
			'slide-left'   => 'Slide from left',
			'slide-right'  => 'Slide from right',
			'slide-top'    => 'Slide from top',
			'slide-bottom' => 'Slide from bottom',
			'scale'        => 'Scale',
		],
		'dependency' => [
			'main_menu_type'                 => 'standard-menu',
			'menu_standard_menu_bar_visible' => true,
		],
	]
);

// Fullscreen / Alignment
kalium_customize_register_control(
	'menu_full_bg_alignment',
	[
		'type'          => 'kalium-select',
		'label'         => 'Content Alignment',
		'heading_title' => 'Fullscreen Menu Options',
		'input_style'   => 'width:120px',
		'choices'       => [
			'left'                => 'Left',
			'centered'            => 'Centered',
			'centered-horizontal' => 'Horizontal (Centered)',
		],
		'dependency'    => [
			'main_menu_type' => 'full-bg-menu',
		],
	]
);

// Search Field
kalium_customize_register_control(
	'menu_full_bg_search_field',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Search Field',
		'default'    => true,
		'dependency' => [
			'main_menu_type' => 'full-bg-menu',
		],
	]
);

// Top Menu / Menu
$menus_list = array_merge(
	[
		[
			'value' => 'main-menu',
			'label' => '- Main Menu -',
		],
	],
	kalium_header_get_menu_choices()
);

kalium_customize_register_control(
	'menu_top_menu_id',
	[
		'type'          => 'kalium-select',
		'label'         => 'Menu',
		'heading_title' => 'Off-Canvas Top Menu Options',
		'input_style'   => 'width:130px',
		'choices'       => array_merge(
			$menus_list,
			[
				[
					'value' => '-',
					'label' => '(No menu)',
				],
			]
		),
		'default'       => 'main-menu',
		'dependency'    => [
			'main_menu_type' => 'top-menu',
		],
	]
);

// Items per Row
kalium_customize_register_control(
	'menu_top_items_per_row',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Items per Row',
		'input_style' => 'width:130px',
		'min'         => 1,
		'max'         => 10,
		'default'     => 1,
		'dependency'  => [
			'main_menu_type' => 'top-menu',
		],
	]
);

// Widgets
kalium_customize_register_control(
	'menu_top_show_widgets',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Widgets',
		'default'    => true,
		'dependency' => [
			'main_menu_type' => 'top-menu',
		],
	]
);

// Columns
kalium_customize_register_control(
	'menu_top_widgets_per_row',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Columns',
		'input_style' => 'width:130px',
		'min'         => 1,
		'max'         => 4,
		'default'     => 3,
		'dependency'  => [
			'main_menu_type'        => 'top-menu',
			'menu_top_show_widgets' => true,
		],
	]
);

// Container Width
kalium_customize_register_control(
	'menu_top_widgets_container_width',
	[
		'type'        => 'kalium-select',
		'label'       => 'Container',
		'input_style' => 'width:130px',
		'choices'     => [
			'col-3' => '25% of row width',
			'col-4' => '33% of row width',
			'col-5' => '40% of row width',
			'col-6' => '50% of row width',
			'col-7' => '60% of row width',
			'col-8' => '65% of row width',
			'col-9' => '75% of row width',
		],
		'default'     => 'col-8',
		'dependency'  => [
			'main_menu_type'        => 'top-menu',
			'menu_top_show_widgets' => true,
		],
	]
);

// Sidebar widgets
kalium_customize_register_control(
	'_kalium_menu_top_widgets',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Manage Widgets',
		'section_link' => 'widgets',
		'dependency'   => [
			'main_menu_type'        => 'top-menu',
			'menu_top_show_widgets' => true,
		],
	]
);

// Force include
kalium_customize_register_control(
	'menu_top_force_include',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Force Include',
		'help'       => 'When you are not using Top Menu as main menu you can alternatively include it by enabling this option.
		Enable this option when you separately want to show this menu type by clicking an element with <strong>.top-menu-toggle</strong> class.',
		'dependency' => [
			'main_menu_type' => 'top-menu',
		],
	]
);

// Type 4 - Menu
kalium_customize_register_control(
	'menu_sidebar_menu_id',
	[
		'type'          => 'kalium-select',
		'heading_title' => 'Off-Canvas Side Menu Options',
		'label'         => 'Menu',
		'input_style'   => 'width:130px',
		'choices'       => array_merge(
			$menus_list,
			[
				[
					'value' => '-',
					'label' => '(No menu)',
				],
			]
		),
		'default'       => 'main-menu',
		'dependency'    => [
			'main_menu_type' => 'sidebar-menu',
		],
	]
);

// Widgets
kalium_customize_register_control(
	'menu_sidebar_show_widgets',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Widgets',
		'default'    => true,
		'dependency' => [
			'main_menu_type' => 'sidebar-menu',
		],
	]
);

// Sidebar widgets
kalium_customize_register_control(
	'_kalium_menu_sidebar_widgets',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Manage Widgets',
		'section_link' => 'widgets',
		'dependency'   => [
			'main_menu_type'            => 'sidebar-menu',
			'menu_sidebar_show_widgets' => true,
		],
	]
);

// Sidebar Alignment
kalium_customize_register_control(
	'menu_sidebar_alignment',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Alignment',
		'choices'    => [
			'left'  => [
				'label' => 'Left',
				'icon'  => 'justifyLeft',
				'size'  => 16,
			],
			'right' => [
				'label' => 'Right',
				'icon'  => 'justifyRight',
				'size'  => 16,
			],
		],
		'default'    => 'right',
		'dependency' => [
			'main_menu_type' => 'sidebar-menu',
		],
	]
);

// Force Include
kalium_customize_register_control(
	'menu_sidebar_force_include',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Force Include',
		'help'       => 'When you are not using Sidebar Menu as main menu you can alternatively include it by enabling this option.
		Enable this option when you separately want to show this menu type by clicking an element with <strong>.sidebar-menu-toggle</strong> class.',
		'dependency' => [
			'main_menu_type' => 'sidebar-menu',
		],
	]
);

// Custom Header
kalium_customize_register_control(
	'kalium_header_custom_header',
	[
		'type'          => 'kalium-section-link',
		'heading_title' => 'Custom Menu Options',
		'label'         => 'Header Builder',
		'section_link'  => kalium()->customize->section_id( 'custom_header' ),
		'dependency'    => [
			'main_menu_type' => 'custom-header',
		],
	]
);

// Sticky header
kalium_customize_register_control(
	'sticky_header',
	[
		'type'          => 'kalium-toggle',
		'label'         => 'Sticky Header',
		'heading_title' => 'Header Settings',
		'separator'     => true,
		'section_link'  => kalium()->customize->section_id( 'sticky_header' ),
	]
);

// Top Header Bar
kalium_customize_register_control(
	'top_header_bar',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Top Bar',
		'section_link' => kalium()->customize->section_id( 'top_bar' ),
	]
);

// Full width header
kalium_customize_register_control(
	'header_fullwidth',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Full Width Container',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Transparent Header
kalium_customize_register_control(
	'header_transparent',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Transparent Header',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Header spacing
kalium_customize_register_control(
	'header_spacing',
	[
		'type'             => 'kalium-range',
		'label'            => 'Spacing',
		'reset'            => true,
		'min'              => 0,
		'max'              => 600,
		'initial_position' => 0,
		'placeholder'      => 0,
		'suffix'           => 'PX',
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'header_transparent' => true,
		],
	]
);

// Submenu Arrow
kalium_customize_register_control(
	'submenu_dropdown_indicator',
	[
		'type'          => 'kalium-toggle',
		'label'         => 'Submenu Arrow',
		'heading_title' => 'Other Settings',
		'separator'     => true,
		'default'       => true,
		'help'          => 'Show dropdown caret for menu links with submenu.',
	]
);

// Hamburger Icon Label
kalium_customize_register_control(
	'menu_hamburger_custom_label',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Hamburger Icon Label',
		'help'         => 'Instead of three horizontal bars you can replace the icon with text or use both.',
		'section_link' => kalium()->customize->section_id( 'hamburger_icon_label' ),
	]
);

// Search field
kalium_customize_register_control(
	'header_search_field',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Search',
		'section_link' => kalium()->customize->section_id( 'search' ),
		'dependency'   => [
			'main_menu_type' => [
				'value'   => 'custom-header',
				'compare' => '!=',
			],
		],
	]
);

// Mini cart
kalium_customize_register_control(
	'header_mini_cart',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Cart',
		'section_link' => kalium()->customize->section_id( 'cart' ),
		'help'         => $is_woocommerce_active ? '' : 'WooCommerce should be installed and activated in order this option to work.',
		'disabled'     => ! $is_woocommerce_active,
		'dependency'   => [
			'main_menu_type' => [
				'value'   => 'custom-header',
				'compare' => '!=',
			],
		],
	]
);

// Language switcher
kalium_customize_register_control(
	'header_wpml_language_switcher',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Language Switcher',
		'disabled'     => ! $is_wpml_active,
		'help'         => $is_wpml_active ? '' : 'WPML plugin should be installed and activated in order this option to work.',
		'section_link' => kalium()->customize->section_id( 'wpml_language_switcher' ),
		'dependency'   => [
			'main_menu_type' => [
				'value'   => 'custom-header',
				'compare' => '!=',
			],
		],
	]
);

// Mobile Menu
kalium_customize_register_control(
	'kalium_header_mobile_menu',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Mobile Menu',
		'separator'    => true,
		'section_link' => kalium()->customize->section_id( 'mobile_menu' ),
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Style Tab
require_once 'header-style.php';

// End of style tab
kalium_customize_end_tab();

/**
 * Subsection: Custom Header.
 */

// Subsection: Custom Header
kalium_customize_register_section(
	'custom_header',
	[
		'title' => 'Custom Header',
	]
);

// Content
kalium_customize_register_control(
	'header_content',
	[
		'type'            => 'laborator-builder',
		'content_type_id' => 'legacy_header',
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Hamburger Icon Label.
 */

// Subsection: Hamburger Icon Label
kalium_customize_register_section(
	'hamburger_icon_label',
	[
		'title' => 'Hamburger Icon Label',
	]
);

// Show Menu Text
kalium_customize_register_control(
	'menu_hamburger_custom_label_text',
	[
		'type'        => 'kalium-text',
		'label'       => 'Display Text',
		'default'     => 'MENU',
		'input_style' => 'width:100px',
	]
);

// Hide Menu Text
kalium_customize_register_control(
	'menu_hamburger_custom_label_close_text',
	[
		'type'        => 'kalium-text',
		'label'       => 'Close Text',
		'default'     => 'CLOSE',
		'input_style' => 'width:100px',
	]
);

// Hamburger Icon Visibility
kalium_customize_register_control(
	'menu_hamburger_custom_icon',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Icon',
		'default' => true,
	]
);

// Hamburger Icon Alignment
kalium_customize_register_control(
	'menu_hamburger_custom_icon_position',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Icon Alignment',
		'choices'    => [
			'left'  => 'Left',
			'right' => 'Right',
		],
		'dependency' => [
			'menu_hamburger_custom_icon' => true,
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Search.
 */

kalium_customize_register_section(
	'search',
	[
		'title' => 'Search',
	]
);

// Search field icon animation
kalium_customize_register_control(
	'header_search_field_animate_icon',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Animate Search Icon',
		'default'    => true,
		'dependency' => [
			'header_search_field' => true,
			'main_menu_type'      => [
				'value'   => 'custom-header',
				'compare' => '!=',
			],
		],
	]
);

// Search field icon animation type
kalium_customize_register_control(
	'header_search_field_icon_animation',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Animation Type',
		'choices'    => [
			'shift' => 'Shift',
			'scale' => 'Scale',
		],
		'default'    => 'scale',
		'dependency' => [
			'header_search_field'              => true,
			'header_search_field_animate_icon' => true,
			'main_menu_type'                   => [
				'value'   => 'custom-header',
				'compare' => '!=',
			],
		],
	]
);

// End of search section
kalium_customize_end_section();

/**
 * Subsection: Fullscreen Menu Background.
 */

// Subsection: Full Screen Menu Background
kalium_customize_register_section(
	'fullscreen_menu_bg',
	[
		'title' => 'Custom Background',
	]
);

// Background color
kalium_customize_register_control(
	'fullscreen_menu_bg_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Color',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors.color-1', 0.9 ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Background image
kalium_customize_register_control(
	'fullscreen_menu_bg_image',
	[
		'type'           => 'kalium-media',
		'label'          => 'Image',
		'library_params' => [
			'type' => 'image',
		],
	]
);

// Background position
kalium_customize_register_control(
	'fullscreen_menu_bg_position',
	[
		'type'  => 'kalium-align-matrix',
		'label' => 'Position',
		'width' => 40,
	]
);

// Background repeat
kalium_customize_register_control(
	'fullscreen_menu_bg_repeat',
	[
		'type'        => 'kalium-select',
		'label'       => 'Repeat',
		'input_style' => 'width:120px',
		'choices'     => [
			'repeat'    => 'Repeat',
			'repeat-x'  => 'Repeat X',
			'repeat-y'  => 'Repeat Y',
			'no-repeat' => 'No Repeat',
		],
	]
);

// Background size
kalium_customize_register_control(
	'fullscreen_menu_bg_size',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Size',
		'choices' => [
			'cover'   => 'Cover',
			'contain' => 'Contain',
			'custom'  => 'Custom',
		],
	]
);

// Background size custom
kalium_customize_register_control(
	'fullscreen_menu_bg_size_custom',
	[
		'type'        => 'kalium-text',
		'label'       => 'Custom Size',
		'input_style' => 'width:100px',
		'placeholder' => 'e.g. 200px',
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Cart.
 */

// Subsection: Cart
kalium_customize_register_section(
	'cart',
	[
		'title' => 'Cart',
	]
);

// Icon
kalium_customize_register_control(
	'header_cart_icon',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Icon',
		'choices' => [
			'icon-1' => [
				'icon' => 'kalium-icon-shopping-bag',
				'size' => 16,
			],
			'icon-2' => [
				'icon' => 'kalium-icon-shopping-cart',
				'size' => 16,
			],
			'icon-3' => [
				'icon' => 'kalium-icon-shopping-basket',
				'size' => 16,
			],
			'none'   => [
				'label' => 'None',
			],
		],
	]
);

// Title
kalium_customize_register_control(
	'header_mini_cart_title',
	[
		'type'        => 'kalium-text',
		'label'       => 'Title',
		'input_style' => 'width:120px',
	]
);

// Hide Empty
kalium_customize_register_control(
	'header_cart_hide_empty',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Hide when Empty',
		'help'  => 'Hide cart icon when its empty.',
	]
);

// Counter
kalium_customize_register_control(
	'header_cart_counter_badge',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Counter Badge',
		'default' => true,
		'help'    => 'Show number of items in cart.',
	]
);

// Click Action
kalium_customize_register_control(
	'header_cart_click_action',
	[
		'type'    => 'kalium-select',
		'label'   => 'Click Action',
		'choices' => [
			'cart-page' => 'Go to Cart Page',
			'mini-cart' => 'Show Mini Cart',
		],
		'default' => 'mini-cart',
	]
);

// Popup Show on
kalium_customize_register_control(
	'header_cart_popup_show_on',
	[
		'type'          => 'kalium-radio-button',
		'heading_title' => 'Cart Popup',
		'label'         => 'Show On',
		'separator'     => true,
		'choices'       => [
			'click' => 'Click',
			'hover' => 'Hover',
		],
		'dependency'    => [
			'header_cart_click_action' => 'mini-cart',
		],
	]
);

// Popup Align
kalium_customize_register_control(
	'header_mini_popup_align',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Alignment',
		'choices'    => [
			'left'   => [
				'label' => 'Left',
				'icon'  => 'justifyLeft',
			],
			'center' => [
				'label' => 'Center',
				'icon'  => 'justifyCenter',
			],
			'right'  => [
				'label' => 'Right',
				'icon'  => 'justifyRight',
			],
		],
		'dependency' => [
			'header_cart_click_action' => 'mini-cart-popup',
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Language Switcher.
 */

// Subsection: WPML Language Switcher
kalium_customize_register_section(
	'wpml_language_switcher',
	[
		'title' => 'Language Switcher',
	]
);

// Show flag
kalium_customize_register_control(
	'header_wpml_language_flag',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Show Flag',
		'default' => true,
	]
);

// Flag position
kalium_customize_register_control(
	'header_wpml_language_flag_position',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Flag Position',
		'choices'    => [
			'left'  => [
				'label' => 'Left',
				'icon'  => 'justifyLeft',
				'size'  => 16,
			],
			'right' => [
				'label' => 'Right',
				'icon'  => 'justifyRight',
				'size'  => 16,
			],
		],
		'dependency' => [
			'header_wpml_language_flag' => true,
		],
	]
);

// Show text
kalium_customize_register_control(
	'header_wpml_language_switcher_text',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Show Label',
		'default' => true,
	]
);

// Display Label
kalium_customize_register_control(
	'header_wpml_language_switcher_text_display_type',
	[
		'type'        => 'kalium-select',
		'label'       => 'Label Format',
		'input_style' => 'width:140px',
		'choices'     => [
			'name'            => 'Native name',
			'translated'      => 'Translated name',
			'initials'        => 'Initials',
			'name-translated' => 'Native name (Translated name)',
			'translated-name' => 'Translated name (Native name)',
		],
		'dependency'  => [
			'header_wpml_language_switcher_text' => true,
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Sticky Header.
 */

require_once __DIR__ . '/sticky-header.php';

/**
 * Subsection: Top Bar.
 */

require_once __DIR__ . '/top-bar.php';

/**
 * Subsection: Mobile menu.
 */

require_once __DIR__ . '/mobile-menu.php';


/**
 * Update options in preview.
 */

// Transparent header and fullwidth header
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'header_transparent',
			'header_spacing',
			'header_fullwidth',
		],
		'content' => 'var body = data.api.getElement( "body" ),
		headerContainer = data.api.getElement( ".site-header" );

		// Transparent header
		body.classList[ data.header_transparent ? "add" : "remove" ]( "header-absolute" );
			
		// Fullwidth header
		headerContainer.classList[ data.header_fullwidth ? "add" : "remove" ]( "fullwidth-header" );
		
		if ( document.querySelector( ".top-menu-container" ) ) {
			var topMenuContainer = document.querySelector( ".top-menu-container > div" );
			
			topMenuContainer.classList[ data.header_fullwidth ? "remove" : "add" ]( "container" );
			topMenuContainer.classList[ data.header_fullwidth ? "add" : "remove" ]( "container-full" );
		}',
	]
);

// Transparent header spacing
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'header_transparent',
			'header_spacing',
		],
		'content' => '.wrapper {
			<# if ( data.header_transparent ) { #>
			padding-top: {{ data.header_spacing || 0 }}px;
			<# } else { #>
			padding-top: inherit;
			<# } #>
		}
		
		.site-header {
			position: {{ data.header_transparent ? "absolute" : "relative" }};
		}',
	]
);
