<?php
/**
 * Kalium WordPress Theme
 *
 * Backup options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Export Options
kalium_customize_register_control(
	'export_options',
	[
		'type'          => 'kalium-options-export',
		'heading_title' => 'Export Options',
		'button_text'   => 'Export Theme Options',
		'description'   => 'This will export all modified theme options in JSON format.',
	]
);

// Import Options
kalium_customize_register_control(
	'import_options',
	[
		'type'               => 'kalium-options-import',
		'heading_title'      => 'Import Options',
		'separator'          => 1,
		'description'        => 'Upload valid JSON file format generated by Kalium Theme Options exporter.',
		'select_text'        => 'Click or drop to upload a file...',
		'button_text'        => 'Import Theme Options',
		'invalid_mime_text'  => 'Only JSON files are allowed!',
		'invalid_type_text'  => 'This is not a valid Kalium Theme Options file!',
		'import_failed_text' => 'Import options failed. Make sure you have uploaded valid import file!',
	]
);

// Transfer Options
kalium_customize_register_control(
	'transfer_options',
	[
		'type'          => 'kalium-options-export',
		'heading_title' => 'Transfer Options',
		'transfer_mode' => is_child_theme() ? 'parent' : 'child',
		'description'   => 'Transfer theme options from the parent or child theme.',
		'separator'     => 1,
	]
);

// Reset Options
kalium_customize_register_control(
	'reset_options',
	[
		'type'          => 'kalium-options-reset',
		'heading_title' => 'Reset Options',
		'separator'     => 1,
		'button_text'   => 'Reset Theme Options',
		'description'   => 'All current customizations will be reset to their default value. You cannot undo this option unless you have exported theme options.',
	]
);
