<?php
/**
 * Kalium WordPress Theme
 *
 * Project page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_post_types_portfolio_project',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Project Page',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'single' ),
	]
);

/**
 * Section: Project Page.
 */

// Section
kalium_customize_register_section(
	'single',
	[
		'title' => 'Project Page',
	]
);

// Navigation
kalium_customize_register_control(
	'portfolio_navigation',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Navigation',
		'section_link' => kalium()->customize->section_id( 'navigation' ),
	]
);

// Social Sharing
kalium_customize_register_control(
	'portfolio_share_item',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Social Sharing',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'social_sharing' ),
	]
);

// Lightbox
kalium_customize_register_control(
	'portfolio_gallery_lightbox',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Lightbox',
		'default' => true,
		'help'    => 'Open gallery images in Lightbox',
	]
);

// Gallery
kalium_customize_register_control(
	'gallery',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Gallery',
		'section_link' => kalium()->customize->section_id( 'gallery' ),
	]
);

/**
 * Subsection: Navigation.
 */

// Subsection: Navigation
kalium_customize_register_section(
	'navigation',
	[
		'title' => 'Navigation',
	]
);

// Portfolio Navigation settings
kalium()->customize->register_post_navigation_settings(
	'portfolio_navigation',
	[
		'post_type'    => 'portfolio',
		'layout_types' => [
			'type-1',
			'type-2',
			'type-3',
		],
		'defaults'     => [
			'subtitle'          => false,
			'archive'           => true,
			'title_custom_prev' => __( 'Previous project', 'kalium' ),
			'title_custom_next' => __( 'Next project', 'kalium' ),
			'subtitle_position' => 'below',
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Social Sharing.
 */

// Subsection: Social Sharing
kalium_customize_register_section(
	'social_sharing',
	[
		'title' => 'Social Sharing',
	]
);

// Like & Share Layout
kalium_customize_register_control(
	'portfolio_like_share_layout',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Layout',
		'choices' => [
			'default' => 'Labels',
			'rounded' => 'Icons',
		],
		'default' => 'rounded',
	]
);

// Share Networks
kalium_customize_register_control(
	'portfolio_share_item_networks',
	[
		'type'            => 'laborator-builder',
		'label'           => 'Share Networks',
		'content_type_id' => 'social_share_networks',
		'separator'       => true,
		'separator_type'  => 3,
		'default'         => static function () {
			return laborator_builder_get_content_type( 'social_share_networks' )->get_default_content();
		},
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Gallery.
 */

// Subsection: Gallery
kalium_customize_register_section(
	'gallery',
	[
		'title' => 'Gallery',
	]
);

// Image Captions
kalium_customize_register_control(
	'portfolio_gallery_captions',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Image Captions',
		'default' => true,
	]
);

// Caption Position
kalium_customize_register_control(
	'portfolio_gallery_caption_position',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Caption Position',
		'choices'    => [
			'hover' => 'Hover',
			'below' => 'Below',
		],
		'dependency' => [
			'portfolio_gallery_captions' => true,
		],
	]
);

// Project gallery image size
kalium()->customize->register_image_size_settings(
	'portfolio_gallery',
	[
		'default' => 'large',
	]
);

// End of current section
kalium_customize_end_section();

// End of parent section (kalium_post_types_portfolio_project)
kalium_customize_end_section();
