<?php
/**
 * Kalium WordPress Theme
 *
 * Brand options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/** @var WP_Customize_Manager $wp_customize */
global $wp_customize;

// Section link control
kalium_customize_register_control(
	'kalium_styling_brand',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Brand',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'brand' ),
	]
);

/**
 * Section: Brand.
 */

// Section
kalium_customize_register_section(
	'brand',
	[
		'title' => 'Brand',
	]
);

// Move site title and tagline to this section
if ( isset( $wp_customize ) ) {
	$blog_name        = $wp_customize->get_control( 'blogname' );
	$blog_description = $wp_customize->get_control( 'blogdescription' );

	$wp_customize->remove_control( $blog_name->id );
	$wp_customize->remove_control( $blog_description->id );

	// Blog name
	kalium_customize_register_control(
		'blogname',
		[
			'type'        => 'kalium-text',
			'label'       => $blog_name->label,
			'default'     => $wp_customize->get_setting( 'blogname' )->default,
			'input_style' => 'width:120px',
			'setting'     => false,
		]
	);

	// Blog description
	kalium_customize_register_control(
		'blogdescription',
		[
			'type'        => 'kalium-text',
			'label'       => $blog_description->label,
			'default'     => $wp_customize->get_setting( 'blogdescription' )->default,
			'input_style' => 'width:120px',
			'help'        => 'Tagline is a short description of your site, a summary or a motto of your site that shows after the title tag.',
			'setting'     => false,
		]
	);
}

// Use uploaded logo
kalium_customize_register_control(
	'use_uploaded_logo',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Site Logo',
	]
);

// Site Logo
kalium_customize_register_control(
	'custom_logo_image',
	[
		'type'           => 'kalium-media',
		'select_label'   => 'Select Site Logo',
		'library_params' => [
			'type' => 'image',
		],
		'dependency'     => [
			'use_uploaded_logo' => true,
		],
	]
);

// Max Logo Width
kalium_customize_register_control(
	'custom_logo_max_width',
	[
		'type'       => 'kalium-range',
		'label'      => 'Logo Width',
		'reset'      => true,
		'responsive' => true,
		'suffix'     => 'PX',
		'min'        => 10,
		'max'        => 500,
		'default'    => 150,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'use_uploaded_logo' => true,
		],
	]
);

/**
 * Display site icon in Brand section.
 *
 * @global WP_Customize_Manager $wp_customize
 */
if ( isset( $wp_customize ) && ( $site_icon = $wp_customize->get_control( 'site_icon' ) ) ) {
	$site_icon->section = 'kalium_styling_brand';
	$site_icon_priority = $site_icon->priority + 11;
}

// Tab Color
kalium_customize_register_control(
	'google_theme_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Tab Color',
		'help'         => 'Applies only on browsers that support <i>theme-color</i> feature (<a href="https://useyourloaf.com/blog/safari-15-theme-color/" target="_blank" rel="noopener noreferrer">learn more</a>).',
		'priority'     => $site_icon_priority ?? null,
		'default'      => kalium_color_reference( 'theme_colors.color-1' ),
		'reset'        => true,
		'enable_alpha' => false,
	]
);

// End of current section
kalium_customize_end_section();


/**
 * Update options in preview.
 */

// Logo max width
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'use_uploaded_logo',
			'custom_logo_image',
			'custom_logo_max_width',
		],
		'content' => <<<EOD
{{{ data.api.printInlineStyle( {
	selector: '.header-logo',
	value: data.custom_logo_max_width,
	parser: function( maxWidth ) {
		if ( data.custom_logo_image && data.api.isNumber( maxWidth ) ) {
			var aspectRatio = maxWidth / data.custom_logo_image.width;
				
			return {
				[ data.api.cssVarName( 'logo-width' ) ]: maxWidth + 'px',
				[ data.api.cssVarName( 'logo-height' ) ]: parseInt( data.custom_logo_image.height * aspectRatio, 10 ) + 'px',
			};
		}
	}
} ) }}}
EOD,
	]
);
