<?php
/**
 * Kalium WordPress Theme
 *
 * Buttons.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_styling_buttons',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Buttons',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'buttons' ),
	]
);

/**
 * Section: Buttons.
 */

// Section
kalium_customize_register_section(
	'buttons',
	[
		'title' => 'Buttons',
	]
);

// Text color
kalium_customize_register_control(
	'button_color',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Color',
		'label'         => 'Text',
		'reset'         => true,
		'choices'       => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'       => [
			'normal' => kalium_color_reference( 'theme_colors_body' ),
			'hover'  => kalium_color_reference( 'button_color.normal' ),
			'active' => kalium_color_reference( 'button_color.hover' ),
		],
		'tooltip'       => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Background color
kalium_customize_register_control(
	'button_bg',
	[
		'type'    => 'kalium-color',
		'label'   => 'Background',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default' => [
			'normal' => kalium_color_reference( 'theme_colors_link.normal' ),
			'hover'  => kalium_color_reference( 'theme_colors_link.hover' ),
			'active' => kalium_color_variant_active( 'button_bg.hover' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Box shadow
kalium_customize_register_control(
	'button_shadow',
	[
		'type'               => 'kalium-box-shadow',
		'heading_title'      => 'Box Shadow',
		'label'              => 'Normal',
		'separator'          => true,
		'reset'              => true,
		'placeholder'        => [
			'offset_x'      => 0,
			'offset_y'      => 0,
			'blur_radius'   => 0,
			'spread_radius' => 0,
		],
		'enable_color_clear' => true,
		'units'              => kalium_get_default_units( 'box-size' ),
		'setting'            => [
			'transport' => 'postMessage',
		],
	]
);

// Box shadow hover
kalium_customize_register_control(
	'button_shadow_hover',
	[
		'type'               => 'kalium-box-shadow',
		'label'              => 'Hover',
		'reset'              => true,
		'placeholder'        => [
			'offset_x'      => 0,
			'offset_y'      => 2,
			'blur_radius'   => 8,
			'spread_radius' => 0,
		],
		'enable_color_clear' => true,
		'units'              => kalium_get_default_units( 'box-size' ),
		'setting'            => [
			'transport' => 'postMessage',
		],
	]
);

// Box shadow active
kalium_customize_register_control(
	'button_shadow_active',
	[
		'type'               => 'kalium-box-shadow',
		'label'              => 'Active',
		'reset'              => true,
		'placeholder'        => [
			'offset_x'      => 0,
			'offset_y'      => 2,
			'blur_radius'   => 8,
			'spread_radius' => 0,
		],
		'enable_color_clear' => true,
		'units'              => kalium_get_default_units( 'box-size' ),
		'setting'            => [
			'transport' => 'postMessage',
		],
	]
);

// Padding
kalium_customize_register_control(
	'button_padding',
	[
		'type'          => 'kalium-multi-numeric',
		'heading_title' => 'Padding & Border',
		'label'         => 'Padding',
		'separator'     => true,
		'reset'         => true,
		'responsive'    => true,
		'placeholder'   => [
			'top'    => 6,
			'right'  => 12,
			'bottom' => 6,
			'left'   => 12,
		],
		'min'           => 0,
		'max'           => 100,
		'default'       => [
			'link' => true,
		],
		'units'         => kalium_get_default_units( 'length' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Border Radius
kalium_customize_register_control(
	'button_radius',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Border Radius',
		'reset'       => true,
		'responsive'  => true,
		'placeholder' => [
			'top'    => 3,
			'right'  => 3,
			'bottom' => 3,
			'left'   => 3,
		],
		'min'         => 0,
		'max'         => 100,
		'default'     => [
			'link' => true,
		],
		'units'       => kalium_get_default_units( 'length' ),
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// Border color
kalium_customize_register_control(
	'button_border',
	[
		'type'         => 'kalium-border-box',
		'label'        => 'Border',
		'reset'        => true,
		'border_style' => true,
		'slider'       => true,
		'compact'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Border hover color
kalium_customize_register_control(
	'button_border_hover',
	[
		'type'       => 'kalium-color',
		'label'      => 'Border Hover',
		'reset'      => true,
		'dependency' => [
			'button_border' => [
				'validate' => 'has_border',
			],
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Border active color
kalium_customize_register_control(
	'button_border_active',
	[
		'type'       => 'kalium-color',
		'label'      => 'Border Active',
		'reset'      => true,
		'default'    => kalium_color_reference( 'button_border_hover' ),
		'dependency' => [
			'button_border' => [
				'validate' => 'has_border',
			],
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Button style
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'button_border',
			'button_border_hover',
			'button_border_active',
			'button_shadow',
			'button_shadow_hover',
			'button_shadow_active',
			'button_padding',
			'button_radius',
		],
		'content' => <<<EOD
	:root {
		<#
		// Border
        var border = data.api.toBorderBox( data.button_border );
        
        #>
        {{ data.api.cssVarName( "button-border-width" ) }}: {{ border.width }};
        {{ data.api.cssVarName( "button-border-style" ) }}: {{ border.style }};
        {{ data.api.cssVarName( "button-border-color" ) }}: {{ border.color }};
        <#
        
        // Hover border
        if ( data.button_border_hover ) { 
            #>
            {{ data.api.cssVarName( "button-hover-border-color" ) }}: {{ data.api.parseColor( data.button_border_hover ) }};
            <#
        }
        
        // Active border
        if ( data.button_border_active ) { 
            #>
            {{ data.api.cssVarName( "button-active-border-color" ) }}: {{ data.api.parseColor( data.button_border_active ) }};
            <#
        }
		
		// Box shadow
		var shadow = data.api.toBoxShadow( data.button_shadow, "0 0 0", true );
		#>
        {{ data.api.cssVarName( "button-shadow-color" ) }}: {{ shadow.color }};
        {{ data.api.cssVarName( "button-shadow-size" ) }}: {{ shadow.size }};
		
		<#
		// Box shadow on hover
        var hoverShadow = data.api.toBoxShadow( data.button_shadow_hover, "0 2px 8px", true );
        #>
        {{ data.api.cssVarName( "button-hover-shadow-color" ) }}: {{ hoverShadow.color }};
        {{ data.api.cssVarName( "button-hover-shadow-size" ) }}: {{ hoverShadow.size }};
	
	    <#
		// Box shadow on active
        var activeShadow = data.api.toBoxShadow( data.button_shadow_active, "0 2px 8px", true );
        #>
        {{ data.api.cssVarName( "button-active-shadow-color" ) }}: {{ activeShadow.color }};
        {{ data.api.cssVarName( "button-active-shadow-size" ) }}: {{ activeShadow.size }};
	}
    
    {{{ data.api.printInlineStyle( {
        selector: ':root',
        value: data.button_padding,
        varName: 'button-padding',
        parser: function( value ) {
            return data.api.toLength( value, '.375rem .75rem' );
        },
    } ) }}}
    
    {{{ data.api.printInlineStyle( {
        selector: ':root',
        value: data.button_radius,
        varName: 'button-border-radius',
        parser: function( value ) {
            return data.api.toLength( value, '.1875rem' );
        },
    } ) }}}
EOD,
	]
);
