<?php
/**
 * Kalium WordPress Theme
 *
 * Site Frame.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Site Frame
kalium_customize_register_control(
	'theme_borders',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Site Frame',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'site_frame' ),
	]
);

/**
 * Section: Site Frame.
 */

// Section
kalium_customize_register_section(
	'site_frame',
	[
		'title' => 'Site Frame',
	]
);

// Frame Color
kalium_customize_register_control(
	'theme_borders_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Color',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_border' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Frame Width
kalium_customize_register_control(
	'theme_borders_thickness',
	[
		'type'       => 'kalium-range',
		'label'      => 'Width',
		'responsive' => true,
		'reset'      => true,
		'min'        => 0,
		'max'        => 100,
		'default'    => '25px',
		'units'      => kalium_get_default_units( 'box-size' ),
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Frame radius
kalium_customize_register_control(
	'theme_borders_radius',
	[
		'type'             => 'kalium-range',
		'label'            => 'Radius',
		'responsive'       => true,
		'reset'            => true,
		'min'              => 0,
		'slider_max'       => 100,
		'initial_position' => 0,
		'units'            => kalium_get_default_units( 'box-size' ),
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Frame Animation
kalium_customize_register_control(
	'theme_borders_animation',
	[
		'type'    => 'kalium-select',
		'label'   => 'Animation',
		'choices' => [
			'none'  => 'No Animation',
			'fade'  => 'Fade In',
			'slide' => 'Slide In',
		],
		'default' => 'fade',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Animate Duration
kalium_customize_register_control(
	'theme_borders_animation_duration',
	[
		'type'        => 'kalium-text',
		'label'       => 'Duration',
		'input_type'  => 'number',
		'step'        => 0.1,
		'min'         => 0,
		'max'         => 30,
		'suffix'      => 's',
		'placeholder' => 0.45,
		'dependency'  => [
			'theme_borders_animation' => [ 'fade', 'slide' ],
		],
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// Animate Delay
kalium_customize_register_control(
	'theme_borders_animation_delay',
	[
		'type'        => 'kalium-text',
		'label'       => 'Delay',
		'input_type'  => 'number',
		'step'        => 0.1,
		'min'         => 0,
		'max'         => 30,
		'suffix'      => 's',
		'placeholder' => 0.3,
		'dependency'  => [
			'theme_borders_animation'          => [ 'fade', 'slide' ],
			'theme_borders_animation_duration' => [
				'value'   => '0',
				'compare' => '!=',
			],
		],
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// Visibility
kalium()->customize->register_visibility_setting(
	'theme_borders',
	[
		'default' => [
			'desktop',
			'tablet',
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Border width and style
kalium_customize_register_preview_update(
	[
		'type'     => 'css',
		'vars'     => [
			'theme_borders_color',
			'theme_borders_thickness',
			'theme_borders_radius',
			'theme_borders_animation',
			'theme_borders_animation_duration',
			'theme_borders_animation_delay',
			'theme_borders_visibility',
		],
		'selector' => '[data-inline-style="site-frame"]',
		'content'  => <<<EOD
	<# 
	var pageBorder = data.api.getElement( '.page-border' ),
		selector = '.page-borders';

	data.api.applyDeviceVisibilityClasses( pageBorder, data.theme_borders_visibility );
	#>
	
	<# if ( pageBorder ) { #>
		{{{ data.api.printInlineStyle( { selector, varName: 'site-frame-color', value: data.theme_borders_color } ) }}}
		{{{ data.api.printInlineStyle( { selector, varName: 'site-frame-width', value: data.theme_borders_thickness } ) }}}
		{{{ data.api.printInlineStyle( { selector, varName: 'site-frame-radius', value: data.theme_borders_radius } ) }}}
		
		<# if ( 'none' !== data.theme_borders_animation ) { #>
			<#
			data.api.debounce( 'site-frame-animation', 200, () => {
				pageBorder.classList.remove( 'page-border--animated' );
				void pageBorder.offsetWidth;
				pageBorder.classList.add( 'page-border--animated' );
			} )();
			#>
			
			{{{ data.api.printInlineStyle( { selector, varName: 'site-frame-animation', value: 'site-frame-' + data.theme_borders_animation } ) }}}
			{{{ data.api.printInlineStyle( { selector, varName: 'site-frame-animation-duration', value: data.theme_borders_animation_duration, addUnit: 's' } ) }}}
			{{{ data.api.printInlineStyle( { selector, varName: 'site-frame-animation-delay', value: data.theme_borders_animation_delay, addUnit: 's' } ) }}}
		<# } #>
	<# } #>
EOD,
	]
);
