<?php
/**
 * Kalium WordPress Theme
 *
 * Kalium WooCommerce options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// General Settings section link
kalium_customize_register_control(
	'kalium_woocommerce_general_settings',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'General Settings',
		'section_link' => kalium()->customize->section_id( 'general_settings' ),
		'priority'     => 5,
	]
);

// General Settings section
kalium_customize_register_section(
	'general_settings',
	[
		'title' => 'General Settings',
	]
);

// Add to Cart Action
kalium_customize_register_control(
	'shop_add_to_cart_action',
	[
		'type'        => 'kalium-select',
		'label'       => 'Add to Cart Behavior',
		'input_style' => 'width:110px',
		'choices'     => [
			'none'      => 'None',
			'mini-cart' => 'Show Mini Cart',
		],
		'help'        => 'Set the action after the product is added to cart.',
	]
);

// Subsection: Mini cart
require __DIR__ . '/mini-cart.php';

// Subsection: Free shipping bar
require __DIR__ . '/free-shipping-bar.php';

// Subsection: Product badges
require __DIR__ . '/product-badges.php';

// End of current section
kalium_customize_end_section();
