<?php
/**
 * Kalium WordPress Theme
 *
 * Product badges.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Product badges
kalium_customize_register_control(
	'kalium_woocommerce_product_badge',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Product Badge',
		'section_link' => kalium()->customize->section_id( 'product_badge' ),
		'priority'     => 20,
	]
);

/**
 * Subsection: Product Badge.
 */

// Product badges section
kalium_customize_register_section(
	'product_badge',
	[
		'title' => 'Product Badge',
	]
);

// General tab
kalium_customize_general_tab();

// Badge style
kalium_customize_register_control(
	'shop_badges_style',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Badge Style',
		'choices'       => [
			'badge'    => [
				'label' => 'Normal',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/badge-normal.svg' ),
			],
			'circle'   => [
				'label' => 'Circle',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/badge-circle.svg' ),
			],
			'triangle' => [
				'label' => 'Triangle',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/badge-triangle.svg' ),
			],
		],
		'columns'       => 3,
	]
);

// Uppercase
kalium_customize_register_control(
	'shop_badges_upper_case',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Upper Case',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Outline
kalium_customize_register_control(
	'shop_badges_outline',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Outline',
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'shop_badges_style' => 'badge',
		],
	]
);

// Badge size
kalium_customize_register_control(
	'shop_badges_size',
	[
		'type'       => 'kalium-range',
		'label'      => 'Size',
		'reset'      => true,
		'responsive' => true,
		'min'        => 30,
		'max'        => 200,
		'units'      => kalium_get_default_units( [ 'px', '%' ] ),
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'shop_badges_style' => [
				'circle',
				'triangle',
			],
		],
	]
);

// Badge radius
kalium_customize_register_control(
	'shop_badges_radius',
	[
		'type'             => 'kalium-range',
		'label'            => 'Radius',
		'reset'            => true,
		'responsive'       => true,
		'min'              => 0,
		'max'              => 100,
		'initial_position' => 100,
		'placeholder'      => 100,
		'units'            => kalium_get_default_units( [ 'px', '%' ] ),
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'shop_badges_style' => 'circle',
		],
	]
);

// Fixed size
kalium_customize_register_control(
	'shop_badges_fixed_size',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Fixed Size',
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'shop_badges_style' => 'circle',
		],
	]
);

// Sale badge as percentage
kalium_customize_register_control(
	'shop_badges_sale_as_pct',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Sale Badge',
		'label'         => 'Show as Percentage',
		'separator'     => true,
	]
);

// Enabled badges
kalium_customize_register_control(
	'shop_enabled_badges',
	[
		'type'          => 'kalium-checkbox',
		'heading_title' => 'Enabled Badges',
		'separator'     => true,
		'inline_label'  => false,
		'choices'       => [
			'sale'         => 'Sale',
			'featured'     => 'Featured',
			'out-of-stock' => 'Out of Stock',
			'backorder'    => 'Backorder',
		],
		'default'       => [
			'sale',
			'featured',
			'out-of-stock',
			'backorder',
		],
	]
);

// End og general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Sale badge color
kalium_customize_register_control(
	'shop_badge_color_sale',
	[
		'type'    => 'kalium-color',
		'label'   => 'Sale',
		'reset'   => true,
		'choices' => [
			'text' => 'Text',
			'bg'   => 'Background',
		],
		'default' => [
			'text' => kalium_color_reference( 'theme_colors_body' ),
			'bg'   => kalium_color_reference( 'theme_colors.color-1' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Featured badge color
kalium_customize_register_control(
	'shop_badge_color_featured',
	[
		'type'    => 'kalium-color',
		'label'   => 'Featured',
		'reset'   => true,
		'choices' => [
			'text' => 'Text',
			'bg'   => 'Background',
		],
		'default' => [
			'text' => kalium_color_reference( 'theme_colors_body' ),
			'bg'   => kalium_color_reference( 'theme_colors.color-1' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Out of stock badge color
kalium_customize_register_control(
	'shop_badge_color_out_of_stock',
	[
		'type'    => 'kalium-color',
		'label'   => 'Out of Stock',
		'reset'   => true,
		'choices' => [
			'text' => 'Text',
			'bg'   => 'Background',
		],
		'default' => [
			'text' => kalium_color_reference( 'theme_colors_text.normal' ),
			'bg'   => kalium_color_reference( 'theme_colors.color-8' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Backorder badge color
kalium_customize_register_control(
	'shop_badge_color_backorder',
	[
		'type'    => 'kalium-color',
		'label'   => 'Backorder',
		'reset'   => true,
		'choices' => [
			'text' => 'Text',
			'bg'   => 'Background',
		],
		'default' => [
			'text' => '#ffeccf',
			'bg'   => '#bf862f',
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// End style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Preview.
 */

kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'shop_badges_style',
			'shop_badges_size',
			'shop_badges_upper_case',
			'shop_badges_outline',
			'shop_badges_radius',
			'shop_badges_fixed_size',
			'shop_badge_color_sale',
			'shop_badge_color_featured',
			'shop_badge_color_out_of_stock',
			'shop_badge_color_backorder',
		],
		'content' => <<<EOD
	<#
	var elements = data.api.getElements( '.product-badge' );
	var badgeTypes = {
		'shop_badge_color_sale': 'sale',
		'shop_badge_color_featured': 'featured',
		'shop_badge_color_out_of_stock': 'out-of-stock',
		'shop_badge_color_backorder': 'backorder',
	};
	
	// Outline
	var isOutline = 'badge' === data.shop_badges_style && data.shop_badges_outline;
	 
	if ( elements.length ) {
		elements.forEach( function( badge ) {
			data.api.toggleClass( badge, "badge-outline", isOutline );
		} );
	}
	
	// Uppercase
	elements.forEach( function( badge ) {
		data.api.toggleClass( badge, "text-uppercase", data.shop_badges_upper_case );
	} );
	#>
	
	{{{ data.api.printInlineStyle( {
		selector: '.product-badge',
		value: data.shop_badges_size,
		varName: 'product',
		parser: ( value ) => {
			return {
				[ 'circle' === data.shop_badges_style && data.shop_badges_fixed_size ? 'badge-size-fixed' : 'badge-size' ]: value,
			};
		},
	} ) }}}
	
	{{{ data.api.printInlineStyle( {
		selector: '.product-badge',
		varName: 'product-badge-radius',
		value: data.shop_badges_radius,
	} ) }}}

	<#
		
		for ( var settingProp in badgeTypes ) {
			data.api.cssVarReset( [ 'badge-color', 'badge-bg', 'badge-outline-color' ] );
			
			if ( ! data.api.isEmpty( settingProp ) ) {
				var textColor = data.api.parseColor( data[ settingProp ].text );
				var bgColor = data.api.parseColor( data[ settingProp ].bg );
				
				#>
				.product-badge.product-badge--type-{{ badgeTypes[ settingProp ] }} {
					{{ data.api.cssVarName( 'badge-color' ) }}: {{ isOutline ? bgColor : textColor }};
					{{ data.api.cssVarName( 'badge-bg' ) }}: {{ isOutline ? textColor : bgColor }};
					{{ data.api.cssVarName( 'badge-outline-color' ) }}: {{ bgColor }};
				}
				<#
			}
		}
	#>
EOD,

	]
);
