<?php
/**
 * Kalium WordPress Theme
 *
 * Product catalog options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/** @var WP_Customize_Manager $wp_customize */
global $wp_customize;

// Remove Product Columns and Rows controls
if ( isset( $wp_customize ) ) {
	foreach ( [ 'woocommerce_catalog_columns', 'woocommerce_catalog_rows' ] as $control_id ) {
		$wp_customize->remove_control( $control_id );
	}
}

// Section start
kalium()->customize->start_section( 'woocommerce_product_catalog' );

// Loop layout
kalium_customize_register_control(
	'shop_products_view',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Layout',
		'choices'       => [
			'grid' => [
				'label' => 'Grid',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/product-type-1.svg' ),
			],
			'list' => [
				'label' => 'List',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/product-type-2.svg' ),
			],
		],
	]
);

// Products per page
kalium_customize_register_control(
	'shop_products_per_page',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Products per Page',
		'reset'       => true,
		'input_style' => 'width:120px',
		'min'         => -1,
		'max'         => 1000,
		'default'     => 12,
	]
);

// Product columns
kalium_customize_register_control(
	'shop_grid_columns',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Product Columns',
		'reset'       => true,
		'responsive'  => true,
		'input_style' => 'width:120px',
		'min'         => 1,
		'max'         => [
			'desktop' => 6,
			'tablet'  => 4,
			'mobile'  => 2,
		],
		'default'     => [
			'desktop' => 3,
			'tablet'  => 2,
			'mobile'  => 1,
		],
		'setting'     => [
			'transport' => 'postMessage',
		],
		'dependency'  => [
			'shop_columns_switcher' => [
				'value'    => true,
				'relation' => 'OR',
			],
			'shop_products_view'    => 'grid',
		],
	]
);

// Gap
kalium_customize_register_control(
	'shop_grid_gap',
	[
		'type'             => 'kalium-range',
		'label'            => 'Gap',
		'reset'            => true,
		'responsive'       => true,
		'min'              => 0,
		'max'              => 100,
		'initial_position' => 24,
		'placeholder'      => 24,
		'units'            => kalium_get_default_units( 'box-size' ),
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Masonry Layout
kalium_customize_register_control(
	'shop_masonry_mode',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Masonry Mode',
		'help'       => 'Masonry mode positions blocks based on available vertical space instead static rows',
		'dependency' => [
			'shop_columns_switcher' => [
				'value'    => true,
				'relation' => 'OR',
			],
			'shop_products_view'    => 'grid',
		],
	]
);

// Product card section link
kalium_customize_register_control(
	'kalium_woocommerce_product_loop_card',
	[
		'type'           => 'kalium-section-link',
		'heading_title'  => 'Card',
		'separator'      => true,
		'separator_type' => 5,
		'label'          => 'Grid Product Card',
		'section_link'   => kalium()->customize->section_id( 'product_loop_card' ),
	]
);

// List View Product card section link
kalium_customize_register_control(
	'kalium_woocommerce_list_product_loop_card',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'List Product Card',
		'dependency'   => [
			'shop_products_view'          => [
				'value'    => 'list',
				'relation' => 'OR',
			],
			'shop_columns_switcher'       => true,
			'shop_columns_switcher_views' => [
				'value'   => 'list',
				'compare' => 'CONTAINS',
			],
		],
		'section_link' => kalium()->customize->section_id( 'list_product_loop_card' ),
	]
);

// Breadcrumb
kalium_customize_register_control(
	'shop_breadcrumb',
	[
		'type'           => 'kalium-toggle',
		'heading_title'  => 'Page Heading',
		'label'          => 'Breadcrumb',
		'separator'      => true,
		'separator_type' => 5,
	]
);

// Page title
kalium_customize_register_control(
	'shop_title',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Page Title',
	]
);

// Results count
kalium_customize_register_control(
	'shop_results_count',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Results Count',
		'default' => true,
	]
);

// Columns switcher
kalium_customize_register_control(
	'shop_columns_switcher',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Columns Switcher',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'columns_switcher' ),
	]
);

// Product ordering (sorting)
kalium_customize_register_control(
	'shop_catalog_ordering',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Sorting Dropdown',
		'default' => true,
	]
);

// Sidebar
kalium_customize_register_control(
	'shop_sidebar',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Options',
		'label'         => 'Sidebar',
		'separator'     => true,
		'section_link'  => kalium()->customize->section_id( 'sidebar' ),
	]
);

// Catalog mode
kalium_customize_register_control(
	'shop_catalog_mode',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Catalog Mode',
		'help'  => 'Catalog mode allows customers to view product listings and images, but they cannot add items to the cart or proceed to checkout.',
	]
);

// Catalog mode hide prices
kalium_customize_register_control(
	'shop_catalog_mode_hide_prices',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Hide Prices',
		'dependency' => [
			'shop_catalog_mode' => true,
		],
	]
);

// Pagination
kalium_customize_register_control(
	'shop_pagination',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Pagination',
		'section_link' => kalium()->customize->section_id( 'pagination' ),
	]
);

// Category layout
kalium_customize_register_control(
	'shop_category_layout',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Category Box',
		'separator'     => true,
		'choices'       => [
			'type-1' => [
				'label' => 'Type 1',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/category-inside-bottom.svg' ),
			],
			'type-2' => [
				'label' => 'Type 2',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/category-inside-center.svg' ),
			],
			'type-3' => [
				'label' => 'Type 3',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/category-inside-top.svg' ),
			],
			'type-4' => [
				'label' => 'Type 4',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/category-outside-left.svg' ),
			],
			'type-5' => [
				'label' => 'Type 5',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/category-outside-center.svg' ),
			],
			'type-6' => [
				'label' => 'Type 6',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/category-inside-button.svg' ),
			],
		],
		'columns'       => 3,
		'show_labels'   => false,
		'tooltips'      => true,
	]
);

// Category Count
kalium_customize_register_control(
	'shop_category_count',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Show Count',
		'help'    => 'Display the number of products inside a category',
		'default' => true,
	]
);

// Category image size
kalium()->customize->register_image_size_settings(
	'shop_category_image',
	[
		'heading_title'  => '',
		'separator'      => false,
		'default'        => 'custom',
		'default_custom' => [
			'width'  => 500,
			'height' => 290,
		],
	]
);

// Separate Categories
kalium_customize_register_control(
	'shop_category_separate',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Separate Categories',
		'help'       => 'Separate categories from the products in different sections',
		'dependency' => [
			'shop_masonry_mode'                    => false,
			'woocommerce_shop_page_display'        => [
				'value'    => 'both',
				'relation' => 'OR',
			],
			'woocommerce_category_archive_display' => 'both',
		],
	]
);

// Custom HTML content
kalium_customize_register_control(
	'kalium_shop_category_separator',
	[
		'type' => 'kalium-html',
		'html' => '<div class="kalium-customize-control__separator"></div>',
	]
);

/**
 * Subsection: Product card.
 */

// Subsection: Product card
kalium_customize_register_section(
	'product_loop_card',
	[
		'title' => 'Grid Product Card',
	]
);

// Product card
kalium_customize_register_control(
	'product_loop_card',
	[
		'type'            => 'laborator-builder',
		'content_type_id' => 'product_loop_card',
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: List Product card.
 */

// Subsection: List View Product card
kalium_customize_register_section(
	'list_product_loop_card',
	[
		'title' => 'List Product Card',
	]
);

// List Product card
kalium_customize_register_control(
	'list_product_loop_card',
	[
		'type'            => 'laborator-builder',
		'content_type_id' => 'list_product_loop_card',
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Shop sidebar.
 */

// Subsection: Sidebar
kalium_customize_register_section(
	'sidebar',
	[
		'title' => 'Sidebar',
	]
);

// Sidebar align
kalium_customize_register_control(
	'shop_sidebar_align',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Sidebar Alignment',
		'choices'       => [
			'left'  => [
				'label' => 'Left',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/sidebar-left.svg' ),
			],
			'right' => [
				'label' => 'Right',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/sidebar-right.svg' ),
			],
		],
		'default'       => 'right',
	]
);

// Sidebar Toggle
kalium_customize_register_control(
	'shop_sidebar_toggle',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Sidebar Toggle',
		'separator_type' => 5,
		'section_link'   => kalium()->customize->section_id( 'toggle' ),
	]
);

// Sidebar Widgets
kalium_customize_register_control(
	'_kalium_shop_sidebar_widgets',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Sidebar Widgets',
		'section_link' => 'widgets',
	]
);

/**
 * Subsection: Sidebar toggle.
 */

// Subsection: Filters Toggle
kalium_customize_register_section(
	'toggle',
	[
		'title' => 'Sidebar Toggle',
	]
);

// Action
kalium_customize_register_control(
	'shop_sidebar_toggle_action',
	[
		'type'        => 'kalium-radio-image',
		'label'       => 'Toggle Action',
		'choices'     => [
			'sidebar'    => [
				'image' => kalium()->assets_url( 'admin/images/theme-options/sidebar-toggle-action-sidebar.svg' ),
				'label' => 'Sidebar',
			],
			'off-canvas' => [
				'image' => kalium()->assets_url( 'admin/images/theme-options/sidebar-toggle-action-off-canvas.svg' ),
				'label' => 'Off-Canvas',
			],
		],
		'show_labels' => false,
		'tooltips'    => true,
	]
);

// Off-Canvas Title
kalium_customize_register_control(
	'shop_sidebar_toggle_off_canvas_title',
	[
		'type'        => 'kalium-text',
		'label'       => 'Off-Canvas Title',
		'input_style' => 'width:120px',
		'dependency'  => [
			'shop_sidebar_toggle_action' => 'off-canvas',
		],
	]
);

// Default state
kalium_customize_register_control(
	'shop_sidebar_toggle_default_state',
	[
		'type'       => 'kalium-select',
		'label'      => 'Default State',
		'choices'    => [
			'show' => 'Show Sidebar',
			'hide' => 'Hide Sidebar',
		],
		'dependency' => [
			'shop_sidebar_toggle_action' => 'sidebar',
		],
	]
);

// Animate sidebar
kalium_customize_register_control(
	'shop_sidebar_toggle_animate',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Animate Sidebar',
		'help'       => 'When toggling the filter on or off, the visibility of the sidebar will be animated',
		'default'    => true,
		'dependency' => [
			'shop_sidebar_toggle_action' => 'sidebar',
			'shop_masonry_mode'          => false,
		],
	]
);

// Show text
kalium_customize_register_control(
	'shop_sidebar_toggle_show_text',
	[
		'type'           => 'kalium-text',
		'heading_title'  => 'Toggle Button Text',
		'label'          => 'Show',
		'separator'      => true,
		'separator_type' => 5,
		'input_style'    => 'width:120px',
		'placeholder'    => esc_html__( 'Show Filters', 'kalium' ),
	]
);

// Hide text
kalium_customize_register_control(
	'shop_sidebar_toggle_hide_text',
	[
		'type'        => 'kalium-text',
		'label'       => 'Hide',
		'input_style' => 'width:120px',
		'placeholder' => esc_html__( 'Hide Filters', 'kalium' ),
	]
);

// End of current section
kalium_customize_end_section();

// End of current section (sidebar)
kalium_customize_end_section();

/**
 * Subsection: Grid columns selector.
 */

// Subsection: Columns switcher
kalium_customize_register_section(
	'columns_switcher',
	[
		'title' => 'Columns Switcher',
	]
);

// Available views
kalium_customize_register_control(
	'shop_columns_switcher_views',
	[
		'type'         => 'kalium-checkbox',
		'label'        => 'Available Views',
		'inline_label' => false,
		'choices'      => [
			[
				'value' => 'list',
				'label' => 'List',
			],
			[
				'value' => 2,
				'label' => 'Grid columns 2',
			],
			[
				'value' => 3,
				'label' => 'Grid columns 3',
			],
			[
				'value' => 4,
				'label' => 'Grid columns 4',
			],
			[
				'value' => 5,
				'label' => 'Grid columns 5',
			],
			[
				'value' => 6,
				'label' => 'Grid columns 6',
			],
		],
		'default'      => [
			'list',
			3,
			4,
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Pagination.
 */

// Subsection: Pagination
kalium_customize_register_section(
	'pagination',
	[
		'title' => 'Pagination',
	]
);

// Pagination settings
kalium()->customize->register_pagination_settings( 'shop_pagination' );

// End of current section
kalium_customize_end_section();

// End of parent section (woocommerce_product_catalog)
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Products columns and gap
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'shop_grid_columns',
			'shop_grid_gap',
		],
		'content' => <<<EOD
<#
data.api.setResponsiveClassNames( '.products', 'columns', data.shop_grid_columns );
data.api.relayoutIsotope( '.products' );
#>

{{{ data.api.printInlineStyle( {
	selector: '.content-area .products',
	value: data.shop_grid_gap,
	varName: 'grid-gap',
} ) }}}
EOD,
	]
);
