<?php
/**
 * Kalium WordPress Theme
 *
 * Version 4.1.2 upgrade tasks.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

return [
	/**
	 * Shop breadcrumb options migration.
	 */
	static function () {
		kalium_migrate_theme_options_batch(
			[
				[
					'id'     => 'shop_single_navigation',
					'id_new' => 'shop_single_breadcrumb',
				],
				[
					'id'     => 'shop_single_navigation_position',
					'id_new' => 'shop_single_breadcrumb_position',
				],
			]
		);

		return true;
	},

	/**
	 * Post navigation options migration.
	 */
	static function () {
		kalium_migrate_theme_options_batch(
			[
				[
					'id'     => 'blog_post_prev_next',
					'id_new' => 'blog_post_navigation',
				],
				[
					'id'     => 'blog_post_prev_next_reverse',
					'id_new' => 'blog_post_navigation_reverse',
					'filter' => function ( $value ) {
						return ! $value;
					},
				],
				[
					'callback' => function () {
						set_theme_mod( 'blog_post_navigation_subtitle_position', 'above' );
						set_theme_mod( 'blog_post_navigation_subtitle_show_on_hover', true );
					},
				],
			]
		);

		return true;
	},

	/**
	 * Portfolio navigation options migration.
	 */
	static function () {
		kalium_migrate_theme_options_batch(
			[
				[
					'id'     => 'portfolio_prev_next',
					'id_new' => 'portfolio_navigation',
				],
				[
					'id'         => 'portfolio_prev_next_type',
					'id_new'     => 'portfolio_navigation_layout',
					'map_values' => [
						'standard' => 'type-1',
						'fixed'    => 'type-3',
					],
				],
				[
					'id'         => 'portfolio_prev_next_position',
					'id_new'     => 'portfolio_navigation_align_horizontal',
					'map_values' => [
						'left'   => 'start',
						'center' => 'center',
						'right'  => 'end',
					],
				],
				[
					'id'     => 'portfolio_prev_next_show_titles',
					'id_new' => 'portfolio_navigation_title_content_type',
					'filter' => function ( $value ) {
						return $value ? 'post_title' : 'custom';
					},
				],
				[
					'id'     => 'portfolio_prev_next_reverse',
					'id_new' => 'portfolio_navigation_reverse',
					'filter' => function ( $value ) {
						return ! $value;
					},
				],
				[
					'id'     => 'portfolio_prev_next_category',
					'id_new' => 'portfolio_navigation_in_same_term',
				],
				[
					'id'     => 'portfolio_prev_next_taxonomy',
					'id_new' => 'portfolio_navigation_taxonomy',
				],
				[
					'id'     => 'portfolio_archive_url_category',
					'id_new' => 'portfolio_navigation_archive_taxonomy_link',
					'filter' => function ( $value ) {
						set_theme_mod(
							'portfolio_navigation_archive_taxonomy',
							get_theme_mod(
								'portfolio_navigation_taxonomy',
								'portfolio_category'
							)
						);

						return $value;
					},
				],
				[
					'id'     => 'portfolio_archive_url',
					'id_new' => 'portfolio_navigation_archive_url',
				],
			]
		);

		return true;
	},

	/**
	 * Other stuff.
	 */
	static function () {

		// Mobile menu close button color
		$mobile_menu_close_button_color = get_theme_mod( 'mobile_menu_close_button_color' );

		if ( $mobile_menu_close_button_color ) {
			set_theme_mod(
				'mobile_menu_close_button_color',
				[
					'normal' => $mobile_menu_close_button_color,
					'hover'  => $mobile_menu_close_button_color,
				]
			);
		}

		// Replace old CSS selectors for toggle-bars
		if ( kalium_is_imported_demo_content() && 'elementor-architecture' === kalium_get_imported_demo_content() ) {
			wp_update_custom_css_post(
				preg_replace(
					'/\.toggle-bars\s+\.(?:toggle-bars__bar-line|toggle-bars__bar-lines)\s*(?:,\s*\.toggle-bars\s+\.(?:toggle-bars__bar-line|toggle-bars__bar-lines))*\s*\{[^}]*width:\s*([\d.]+px);[^}]*\}/',
					'.toggle-bars { ' . kalium_css_var_name( 'tb-width' ) . ': $1; }',
					wp_get_custom_css()
				)
			);
		}

		return true;
	},
];
