<?php
/**
 * Kalium WordPress Theme
 *
 * Button widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'lab_button',
		'name'        => 'Button',
		'description' => 'Insert button link',
		'category'    => 'Laborator',
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/button.svg' ),
		'params'      => [
			[
				'type'        => 'textfield',
				'heading'     => 'Button Title',
				'param_name'  => 'title',
				'admin_label' => true,
				'value'       => '',
				'std'         => 'Text on the button',
			],
			[
				'type'       => 'vc_link',
				'heading'    => 'Button Link',
				'param_name' => 'link',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Button Type',
				'param_name'  => 'type',
				'std'         => 'default',
				'admin_label' => true,
				'value'       => [
					'Standard'                       => 'standard',
					'Outlined'                       => 'outlined',
					'Outlined with Hover Background' => 'outlined-bg',
					'Flip Hover'                     => 'fliphover',
				],
				'description' => 'Set spacing for logo columns.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Button Size',
				'param_name'  => 'size',
				'std'         => 'btn-normal',
				'value'       => [
					'Mini'   => 'btn-mini',
					'Small'  => 'btn-small',
					'Normal' => 'btn-normal',
					'Large'  => 'btn-large',
				],
				'description' => 'Set spacing for logo columns.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Background Color',
				'param_name'  => 'button_bg',
				'value'       => [
					'Primary'   => 'btn-primary',
					'Secondary' => 'btn-secondary',
					'Black'     => 'btn-black',
					'Blue'      => 'btn-blue',
					'Red'       => 'btn-red',
					'Green'     => 'btn-green',
					'Yellow'    => 'btn-yellow',
					'White'     => 'btn-white',
					'Custom color' => 'custom'
				],
				'std'         => 'btn-primary',
				'description' => 'Select button background (and/or border) color.',
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Custom Background Color',
				'param_name'  => 'button_bg_custom',
				'description' => 'Custom background color for button.',
				'dependency'  => [
					'element' => 'button_bg',
					'value'   => [ 'custom' ],
				],
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Custom Text Color',
				'param_name'  => 'button_txt_custom',
				'description' => 'Custom text color for button.',
				'dependency'  => [
					'element' => 'button_bg',
					'value'   => [ 'custom' ],
				],
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Custom Text Color',
				'param_name'  => 'button_txt_hover_custom',
				'description' => 'Custom text hover color for button (where applied).',
				'dependency'  => [
					'element' => 'button_bg',
					'value'   => [ 'custom' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Button extends WPBakeryShortCode {}
