<?php
/**
 * Kalium WordPress Theme
 *
 * Clients widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$icon = kalium()->file_url( 'includes/wpbakery/assets/images/clients.svg' );

// Clients
vc_map(
	[
		'base'                    => 'lab_clients',
		'name'                    => 'Clients',
		'description'             => 'Partners/clients logos',
		'category'                => 'Laborator',
		'content_element'         => true,
		'show_settings_on_create' => true,
		'icon'                    => $icon,
		'as_parent'               => [ 'only' => 'lab_clients_entry' ],
		'params'                  => [
			[
				'type'        => 'dropdown',
				'heading'     => 'Clients per Row',
				'param_name'  => 'columns_count',
				'std'         => '4',
				'value'       => [
					'2 Logos per Row'  => '2',
					'3 Logos per Row'  => '3',
					'4 Logos per Row'  => '4',
					'5 Logos per Row'  => '5',
					'6 Logos per Row'  => '6',
					'7 Logos per Row'  => '7',
					'8 Logos per Row'  => '8',
					'9 Logos per Row'  => '9',
					'10 Logos per Row' => '10',
					'11 Logos per Row' => '11',
					'12 Logos per Row' => '12',
				],
				'description' => 'Set number of columns for per row.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Spacing',
				'param_name'  => 'column_spacing',
				'std'         => 'no',
				'value'       => [
					'No spacing'            => 'no',
					'Apply default spacing' => 'yes',
				],
				'description' => 'Set spacing for logo columns.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Image Borders',
				'param_name'  => 'image_borders',
				'std'         => 'yes',
				'value'       => [
					'No'  => 'no',
					'Yes' => 'yes',
				],
				'description' => 'Add borders to logo items.',
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Border Color',
				'param_name'  => 'border_color',
				'description' => 'You can set custom hover text color.',
				'dependency'  => [
					'element' => 'image_borders',
					'value'   => [ 'yes' ],
				],
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Hover Style',
				'param_name'  => 'hover_style',
				'std'         => 'full',
				'value'       => [
					'None'                       => 'none',
					'Opacity on hover'           => 'hover-opacity',
					'Full background hover'      => 'full',
					'Distanced background hover' => 'distanced',
				],
				'description' => 'Select hover effect style to apply for client logos.',
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Overlay Background Color',
				'param_name'  => 'hover_bg',
				'description' => 'You can set custom hover color.',
				'dependency'  => [
					'element' => 'hover_style',
					'value'   => [ 'full', 'distanced' ],
				],
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Overlay Text Color',
				'param_name'  => 'hover_txt',
				'description' => 'You can set custom hover text color.',
				'dependency'  => [
					'element' => 'hover_style',
					'value'   => [ 'full', 'distanced' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Image size',
				'param_name'  => 'img_size',
				'description' => 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.',
			],
			[
				'type'        => 'checkbox',
				'heading'     => 'Lazy load images',
				'param_name'  => 'lazy_load',
				'description' => 'Enable lazy loading for logo images (only if browser supports this natively).',
				'value'       => [
					'Yes' => 'yes',
				],
				'std'         => 'yes',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Max Height / Aspect Ratio',
				'param_name'  => 'height',
				'description' => 'You may alternatively specify the height of the logo entries or the aspect ratio (e.g., 1:1 for square entries).',
			],
			\Kalium\Compatibility\WPBakery::$laborator_vc_general_params['reveal_effect'],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
		'js_view'                 => 'VcColumnView',
		'default_content'         => '[lab_clients_entry title="Client 1" description="Sample description here"][lab_clients_entry title="Client 2" description="Sample description here"]',
	]
);

// Client Logo (child of Clients)
vc_map(
	[
		'base'            => 'lab_clients_entry',
		'name'            => 'Client Logo',
		'description'     => 'Member details',
		'category'        => 'Laborator',
		'content_element' => true,
		'icon'            => $icon,
		'as_child'        => [ 'only' => 'lab_clients' ],
		'params'          => [
			[
				'type'        => 'attach_image',
				'heading'     => 'Image',
				'param_name'  => 'image',
				'value'       => '',
				'description' => 'Add logo image here.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Title',
				'param_name'  => 'title',
				'admin_label' => true,
				'description' => 'Title of the client/partner (shown on hover).',
			],
			[
				'type'        => 'textarea',
				'heading'     => 'Description',
				'param_name'  => 'description',
				'description' => 'Small description about the client/partner, this text area supports HTML too (shown on hover).',
			],
			[
				'type'        => 'vc_link',
				'heading'     => 'Link',
				'param_name'  => 'link',
				'description' => 'Make client logo clickable (Optional).',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Clients extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_Lab_Clients_Entry extends WPBakeryShortCode {}
